const KeyMap = {
	"Escape": 0x01,
    "Digit1": 0x02,
    "Digit2": 0x03,
    "Digit3": 0x04,
    "Digit4": 0x05,
    "Digit5": 0x06,
    "Digit6": 0x07,
    "Digit7": 0x08,
    "Digit8": 0x09,
    "Digit9": 0x0A,
    "Digit0": 0x0B,
    "Minus": 0x0C,
    "Equal": 0x0D,
    "Backspace": 0x0E,
    "Tab": 0x0F,
    "KeyQ": 0x10,
    "KeyW": 0x11,
    "KeyE": 0x12,
    "KeyR": 0x13,
    "KeyT": 0x14,
    "KeyY": 0x15,
    "KeyU": 0x16,
    "KeyI": 0x17,
    "KeyO": 0x18,
    "KeyP": 0x19,
    "BracketLeft": 0x1A,
    "BracketRight": 0x1B,
    "Enter": 0x1C,
    "ControlLeft": 0x1D,
    "KeyA": 0x1E,
    "KeyS": 0x1F,
    "KeyD": 0x20,
    "KeyF": 0x21,
    "KeyG": 0x22,
    "KeyH": 0x23,
    "KeyJ": 0x24,
    "KeyK": 0x25,
    "KeyL": 0x26,
    "Semicolon": 0x27,
    "Quote": 0x28,
    "Backquote": 0x29,
    "ShiftLeft": 0x2A,
    "Backslash": 0x2B,
    "KeyZ": 0x2C,
    "KeyX": 0x2D,
    "KeyC": 0x2E,
    "KeyV": 0x2F,
    "KeyB": 0x30,
    "KeyN": 0x31,
    "KeyM": 0x32,
    "Comma": 0x33,
    "Period": 0x34,
    "Slash": 0x35,
    "ShiftRight": 0x36,
    "NumpadMultiply": 0x37,
    "AltLeft": 0x38,
    "Space": 0x39,
    "CapsLock": 0x3A,
    "F1": 0x3B,
    "F2": 0x3C,
    "F3": 0x3D,
    "F4": 0x3E,
    "F5": 0x3F,
    "F6": 0x40,
    "F7": 0x41,
    "F8": 0x42,
    "F9": 0x43,
    "F10": 0x44,
    "NumLock": 0x45,
    "ScrollLock": 0x46,
    "Pause": 0x46,
    "PrintScreen": 0x37,
    "Numpad7": 0x47,
    "Numpad8": 0x48,
    "Numpad9": 0x49,
    "NumpadSubtract": 0x4A,
    "Numpad4": 0x4B,
    "Numpad5": 0x4C,
    "Numpad6": 0x4D,
    "NumpadAdd": 0x4E,
    "Numpad1": 0x4F,
    "Numpad2": 0x50,
    "Numpad3": 0x51,
    "Numpad0": 0x52,
    "NumpadDecimal": 0x53,
    "F11": 0x57,
    "F12": 0x58,
    "ArrowUp": 0x48,    // 上箭头
    "ArrowDown": 0x50,  // 下箭头
    "ArrowLeft": 0x4B,  // 左箭头
    "ArrowRight": 0x4D, // 右箭头
    "Insert": 0x52,
    "Home": 0x47,
    "PageUp": 0x49,
    "Delete": 0x53,
    "End": 0x4F,
    "PageDown": 0x51,
    "ControlRight": 0x1D,
    "AltRight": 0x38,
    "MetaLeft": 0xDB, // Windows/Command key
    "MetaRight": 0xDC,
    "ContextMenu": 0xDD,
};


const VirtualKeyMap = {
    "Escape": 0x1B,       // ESC 键
    "Digit1": 0x31,       // 数字 1
    "Digit2": 0x32,       // 数字 2
    "Digit3": 0x33,       // 数字 3
    "Digit4": 0x34,       // 数字 4
    "Digit5": 0x35,       // 数字 5
    "Digit6": 0x36,       // 数字 6
    "Digit7": 0x37,       // 数字 7
    "Digit8": 0x38,       // 数字 8
    "Digit9": 0x39,       // 数字 9
    "Digit0": 0x30,       // 数字 0
    "Minus": 0xBD,        // 减号 (-)
    "Equal": 0xBB,        // 等号 (=)
    "Backspace": 0x08,    // 退格键
    "Tab": 0x09,          // Tab 键
    "KeyQ": 0x51,         // Q 键
    "KeyW": 0x57,         // W 键
    "KeyE": 0x45,         // E 键
    "KeyR": 0x52,         // R 键
    "KeyT": 0x54,         // T 键
    "KeyY": 0x59,         // Y 键
    "KeyU": 0x55,         // U 键
    "KeyI": 0x49,         // I 键
    "KeyO": 0x4F,         // O 键
    "KeyP": 0x50,         // P 键
    "BracketLeft": 0xDB,  // 左方括号 ([)
    "BracketRight": 0xDD, // 右方括号 (])
    "Enter": 0x0D,        // 回车键
    "ControlLeft": 0x11,  // 左 Ctrl 键
    "KeyA": 0x41,         // A 键
    "KeyS": 0x53,         // S 键
    "KeyD": 0x44,         // D 键
    "KeyF": 0x46,         // F 键
    "KeyG": 0x47,         // G 键
    "KeyH": 0x48,         // H 键
    "KeyJ": 0x4A,         // J 键
    "KeyK": 0x4B,         // K 键
    "KeyL": 0x4C,         // L 键
    "Semicolon": 0xBA,    // 分号 (;)
    "Quote": 0xDE,        // 单引号 (')
    "Backquote": 0xC0,    // 反引号 (`)
    "ShiftLeft": 0x10,    // 左 Shift 键
    "Backslash": 0xDC,    // 反斜杠 (\)
    "KeyZ": 0x5A,         // Z 键
    "KeyX": 0x58,         // X 键
    "KeyC": 0x43,         // C 键
    "KeyV": 0x56,         // V 键
    "KeyB": 0x42,         // B 键
    "KeyN": 0x4E,         // N 键
    "KeyM": 0x4D,         // M 键
    "Comma": 0xBC,        // 逗号 (,)
    "Period": 0xBE,       // 句号 (.)
    "Slash": 0xBF,        // 斜杠 (/)
    "ShiftRight": 0x10,   // 右 Shift 键
    "NumpadMultiply": 0x6A, // 小键盘乘号 (*)
    "AltLeft": 0x12,      // 左 Alt 键
    "Space": 0x20,        // 空格键
    "CapsLock": 0x14,     // 大写锁定键
    "F1": 0x70,           // F1 键
    "F2": 0x71,           // F2 键
    "F3": 0x72,           // F3 键
    "F4": 0x73,           // F4 键
    "F5": 0x74,           // F5 键
    "F6": 0x75,           // F6 键
    "F7": 0x76,           // F7 键
    "F8": 0x77,           // F8 键
    "F9": 0x78,           // F9 键
    "F10": 0x79,          // F10 键
    "NumLock": 0x90,      // 数字锁定键
    "Pause": 0x13,        // 暂停键
    "PrintScreen": 0x2C,  // 打印屏幕键
    "Numpad7": 0x67,      // 小键盘 7
    "Numpad8": 0x68,      // 小键盘 8
    "Numpad9": 0x69,      // 小键盘 9
    "NumpadSubtract": 0x6D, // 小键盘减号 (-)
    "Numpad4": 0x64,      // 小键盘 4
    "Numpad5": 0x65,      // 小键盘 5
    "Numpad6": 0x66,      // 小键盘 6
    "NumpadAdd": 0x6B,    // 小键盘加号 (+)
    "Numpad1": 0x61,      // 小键盘 1
    "Numpad2": 0x62,      // 小键盘 2
    "Numpad3": 0x63,      // 小键盘 3
    "Numpad0": 0x60,      // 小键盘 0
    "NumpadDecimal": 0x6E, // 小键盘小数点 (.)
    "F11": 0x7A,          // F11 键
    "F12": 0x7B,          // F12 键
    "ArrowUp": 0x26,      // 上箭头
    "ArrowDown": 0x28,    // 下箭头
    "ArrowLeft": 0x25,    // 左箭头
    "ArrowRight": 0x27,   // 右箭头
    "Insert": 0x2D,       // 插入键
    "Home": 0x24,         // Home 键
    "PageUp": 0x21,       // Page Up 键
    "Delete": 0x2E,       // 删除键
    "End": 0x23,          // End 键
    "PageDown": 0x22,     // Page Down 键
    "ControlRight": 0x11, // 右 Ctrl 键
    "AltRight": 0x12,     // 右 Alt 键
    "MetaLeft": 0x5B,     // 左 Windows 键
    "MetaRight": 0x5C,    // 右 Windows 键
    "ContextMenu": 0x5D,  // 应用程序键
};



