// 简化版的langI18n，适用于独立HTML
class StandaloneI18n {
  constructor() {
    this.currentLang = window.vite_public_language || 'zh'
    this.messages = {}
    this.loadLanguage(this.currentLang)
  }

  async loadLanguage(lang) {
		try {
			const _this = this
			const isZh = this.currentLang === 'zh'
			const messages = sessionStorage.getItem('langMessages')
			if (messages) {
				this.messages = JSON.parse(messages)
			}
      // 如果是中文，则不需要加载语言包
      if (!isZh) {
				if (!this.messages[lang]) {
					// 如果window.languages中存在，则直接使用window.languages中的语言包
					if (window.languages[lang]) {
						this.messages[lang] = window.languages[lang]
					} else {
						// 动态导入打包后的语言包 JSON 文件
						const response = await fetch(`/static/languages/${lang}.json`)
						const module = await response.json()
						this.messages[lang] = module.data || module.default || module
					}
					sessionStorage.setItem('langMessages', JSON.stringify(this.messages))
				}
			}
			this.currentLang = lang
			console.log(this.currentLang)


      // 获取所有i18n节点
			const i18nElements = document.querySelectorAll('.i18n')
      if (i18nElements)
				i18nElements.forEach(function (element) {
          // 当前元素为img标签时 获取title 并修改title
          if (element.tagName === 'IMG') {
						if (element.title) {
							const dataTitle = element.getAttribute('data-text') || element.title
							element.title = isZh ? dataTitle : _this.t(dataTitle)
						}
          }
          // 当前元素为input标签时 获取placeholder 并修改placeholder
          else if (element.tagName === 'INPUT') {
						const dataText = element.getAttribute('data-text') || element.placeholder
            element.placeholder = isZh ? dataText : _this.t(dataText)
          } else {
            const text = element.getAttribute('data-text') || element.textContent.trim()
						console.log(text, 999, isZh)	
						element.innerHTML = isZh ? text : _this.t(text)
						if (element?.title) {
							const dataTitle = element.getAttribute('data-text') || element.title
							element.title = isZh ? dataTitle : _this.t(dataTitle)
            }
          }
        })
    } catch (error) {
      console.warn(`Failed to load language: ${lang}`)
    }
  }

	t(text, args = []) {
    const key = md5(text)
		const content = this.messages[this.currentLang]?.[key] || text
    return content.replace(/\{(\d+)\}/g, (match, index) => {
      return args[index]
    })
  }
}

// 全局实例
window.i18n = new StandaloneI18n()
window.langI18n = (text, args) => window.i18n.t(text, args)
