#coding: utf-8
import public, db, re, os, time
import zipfile, sys

panelPath = os.getenv('BT_PANEL')
os.chdir(panelPath)
sys.path.insert(0, panelPath + "/class/")


class panelBackup:
    def __init__(self):
        pass

    #备份网站
    def backupSite(self, name):

        sql = db.Sql()
        path = public.M('sites').where('name=?', (name, )).getField('path')
        endDate = time.strftime('%Y/%m/%d %X', time.localtime())
        if not path:
            log = "网站[" + name + "]不存在!"
            print("★[" + endDate + "] " + log)
            print(
                "----------------------------------------------------------------------------"
            )
            return

        backup_path = public.M('config').where(
            "id=?", (1, )).getField('backup_path') + '/site'
        if not os.path.exists(backup_path): os.makedirs(backup_path)
        filename = backup_path + "/Web_" + name + "_" + time.strftime(
            '%Y%m%d_%H%M%S', time.localtime()) + '.zip'

        #ZIP压缩
        self.Zip(path, filename)

        if not os.path.exists(filename):
            log = "网站[" + name + "]备份失败!"
            print("★[" + endDate + "] " + log)
            print(
                "----------------------------------------------------------------------------"
            )
            return False
        try:
            self.clear_site_backup(name, cron=True)
        except:
            pass
        return filename

    def clear_site_backup(self, name, cron=False):
        # 清理多余的本地备份
        sql = db.Sql()
        # 获取备份保存数量
        try:
            if public.M('crontab').where('sName=? and sType=?',('ALL','site')).count() > 0:
                backup_count = public.M('crontab').where('sName=? and sType=?',('ALL','site')).getField('save')
                if not isinstance(backup_count, int) or not backup_count:
                    if not isinstance(backup_count, list) and len(backup_count)>0:
                        backup_count = backup_count[0]
                    else:
                        backup_count = 3
            else:
                backup_count = public.M('crontab').where('sName=? and sType=?', (name,'site')).getField('save')
            if not isinstance(backup_count, int) or not backup_count:
                backup_count = 3
        except:
            backup_count = 3
        pid = public.M('sites').where('name=?', (name, )).getField('id')
        backups = public.M('backup').where('pid=?', (pid,)).field('id,name,filename').order('id desc').select()
        now_count = 0
        if cron:backup_count -= 1
        for i in backups:
            if '|' not in i['filename'] and os.path.exists(i['filename']):
                if os.path.exists(i['filename']):
                    now_count += 1
                    if now_count <= backup_count: continue
                    try:
                        print(i['filename'])
                        os.remove(i['filename'])
                        public.M('backup').where('id=?', (i['id'],)).delete()
                    except:
                        pass



    #备份数据库
    def backupDatabase(self, name):
        sql = db.Sql()
        find = public.M('databases').where('name=?',
                                            (name, )).field('id,type').find()
        endDate = time.strftime('%Y/%m/%d %X', time.localtime())
        if not find['id']:
            log = u"数据库[" + name + u"]不存在!"
            print(u"★[" + endDate + "] " + log)
            print(
                u"----------------------------------------------------------------------------"
            )
            return False

        backup_path = public.M('config').where(
            "id=?", (1, )).getField('backup_path') + '/database'
        if not os.path.exists(backup_path): os.makedirs(backup_path)

        sqlfile = backup_path + "/Db_" + name + "_" + time.strftime(
            '%Y%m%d_%H%M%S', time.localtime()) + ".sql"

        if find['type'].lower() == 'mysql':
            mysql_root = public.M('config').where(
                "id=?", (1, )).getField('mysql_root')
            if public.get_server_status('mysql') < 0:
                log = u"未安装MySQL服务!"
                print(u"★[" + endDate + "] " + log)
                print(
                    u"----------------------------------------------------------------------------"
                )
                return False

            #去mysql安装目录
            _version = re.search('([MySQL|MariaDB-]+\d+\.\d+)',
                                 public.get_server_path('mysql')).groups()[0]
            _setup_path = public.GetConfigValue(
                'setup_path') + '/mysql/' + _version

            try:
                myconf = public.readFile(_setup_path + '/my.ini')
                rep = "port\s*=\s*([0-9]+)"
                port = re.search(rep, myconf).groups()[0].strip()
            except:
                port = '3306'

            public.ExecShell(
                _setup_path +
                "/bin/mysqldump.exe -R -E --hex-blob --opt --force --default-character-set="
                + public.get_database_character(name) + " -P" + port +
                " -uroot -p" + mysql_root + " -R " + name + " > " + sqlfile)
            if not os.path.exists(sqlfile):
                endDate = time.strftime('%Y/%m/%d %X', time.localtime())
                log = u"数据库[" + name + u"]备份失败!"
                print(u"★[" + endDate + "] " + log)
                print(
                    u"----------------------------------------------------------------------------"
                )
                return False
        else:
            if find['type'].lower() != 'mysql':
                print(u"不支持的数据库类型：{} - 数据库名：{}".format(find['type'], name))
                return
            if public.get_server_status('MSSQLSERVER') < 0:
                log = u"未安装SQLServer服务!"
                print(u"★[" + endDate + "] " + log)
                print(
                    u"----------------------------------------------------------------------------"
                )
                return
            import panelMssql
            sqlfile = sqlfile.replace('.sql', '.bak')
            mssql_obj = panelMssql.panelMssql()
            mssql_obj.execute("backup database %s To disk='%s'" %
                              (name, sqlfile))

        filename = sqlfile.replace(".bak", ".zip").replace(".sql", ".zip")
        self.Zip(sqlfile, filename)
        os.remove(sqlfile)
        try:
            self.clear_database_backup(name, cron=True)
        except:
            pass
        return filename


    def clear_database_backup(self, name, cron=False):
        # 清理多余的本地备份
        sql = db.Sql()
        # 获取备份保存数量
        try:
            if public.M('crontab').where('sName=? and sType=?',('ALL','database')).count() > 0:
                backup_count = public.M('crontab').where('sName=? and sType=?',('ALL','database')).getField('save')
                if not isinstance(backup_count, int) or not backup_count:
                    if not isinstance(backup_count, list) and len(backup_count)>0:
                        backup_count = backup_count[0]
                    else:
                        backup_count = 3
            else:
                backup_count = public.M('crontab').where('sName=? and sType=?', (name,'database')).getField('save')
            if not isinstance(backup_count, int) or not backup_count:
                backup_count = 3
        except:
            backup_count = 3
        pid = public.M('databases').where('name=?', (name, )).getField('id')
        backups = public.M('backup').where('pid=?', (pid,)).field('id,name,filename').order('id desc').select()
        now_count = 0
        if cron: backup_count -= 1
        for i in backups:
            if '|' not in i['filename'] and os.path.exists(i['filename']):
                if os.path.exists(i['filename']):
                    now_count += 1
                    if now_count <= backup_count: continue
                    try:
                        os.remove(i['filename'])
                        public.M('backup').where('id=?', (i['id'],)).delete()
                    except:
                        pass


    #备份指定目录
    def backupPath(self, path):
        sql = db.Sql()

        if path[-1:] == '/': path = path[:-1]
        name = os.path.basename(path)
        backup_path = public.M('config').where(
            "id=?", (1, )).getField('backup_path') + '/path'
        if not os.path.exists(backup_path): os.makedirs(backup_path)
        filename = backup_path + "/Path_" + name + "_" + time.strftime(
            '%Y%m%d_%H%M%S', time.localtime()) + '.zip'

        self.Zip(path, filename)
        endDate = time.strftime('%Y/%m/%d %X', time.localtime())
        if not os.path.exists(filename):
            log = u"目录[" + path + "]备份失败"
            print(u"★[" + endDate + "] " + log)
            print(
                u"----------------------------------------------------------------------------"
            )
            return False

        return filename

    #文件压缩
    def Zip(self, sfile, dfile):
        try:
            import zipfile
            filelists = []
            path = sfile
            if os.path.isdir(sfile):
                self.GetFileList(sfile, filelists)
            else:
                path = os.path.dirname(sfile)
                filelists.append(sfile)

            exclude = []
            try:
                key = sys.argv[len(sys.argv) - 1]
                if len(key) == 32:
                    epath = public.GetConfigValue('setup_path') + '/cron/{}.exclude'.format(key)
                    if os.path.exists(epath):
                        body = public.readFile(epath).strip()
                        if body:
                            exclude = body.split('\n')

            except:
                pass

            f = zipfile.ZipFile(dfile, 'w', zipfile.ZIP_DEFLATED)
            for item in filelists:
                if not self.check_exclude(item, exclude):
                    f.write(item, item.replace(path, ''))
            f.close()
            return True
        except:
            return False

    #检查排除目录、文件
    def check_exclude(self, filename, exclude):
        for x in exclude:
            if x: x = x.strip()
            if x.find('*.') != -1 and filename.find('.') != -1:
                if filename.split('.')[-1] == x.split('.')[-1]: return True
            if filename.find(x) >= 0:
                return True
        return False

    #获取所有文件列表
    def GetFileList(self, path, list):
        files = os.listdir(path)
        list.append(path)
        for file in files:
            if os.path.isdir(path + '/' + file):
                self.GetFileList(path + '/' + file, list)
            else:
                list.append(path + '/' + file)