# coding: utf-8
# 统一入口文件
import os, sys, json,time,re
from importlib import reload

from common import M,Md5,FileMd5,get_requests_headers,HttpGet,HttpPost,get_error_info,GetMsg
from common import ReturnJson,GetJson,ReturnMsg,return_error,return_status_code,return_data,returnResult
from common import GetConfigValue,SetConfigValue,GetConfig
from common import get_plugin_path,get_setup_path,get_soft_path,get_panel_path,get_config_value,read_config
from common import xsssec,xsssec2,xsssec3,xss_version,xssencode2,xssdecode
from common import gen_password,GetRandomString,GetRandomString1,GetRandomString2,getStrBetween
from common import IsRestart,exists_args,format_date,to_size,getDate,ExecShell,decode_bytes,process_exists
from common import set_tasks_run,writeSpeed,getSpeed,get_plugin_info,CheckPort,get_search_history,set_search_history
from common import PanelError

from files import ReadFile,WriteFile,GetNumLines
from files import downloadFileByWget,downloadFile
from files import path_safe_check,to_path,format_path
from files import rmdir,rmtree,copytree,move,get_path_size,get_file_list,get_paths,get_dos_disk

from panel import GetWebServer,ServiceReload,get_webserver,is_64bitos,set_system_path,get_sys_version,get_url,submit_panel_bug,getPanelAddr,get_push_info
from panel import GetLocalIp,GetClientIp,get_server_ip,get_local_ip,get_network_ip,check_ip,checkIp,is_ipv4,is_ipv6
from panel import get_php_versions,password_salt,check_salt,checkWebConfig

from process import getCpuType,get_os_version,is_aarch,is_process_exists_by_exe,is_process_exists_by_cmdline,is_process_exists_by_name,is_mysql_process_exists,is_redis_process_exists,is_pure_ftpd_process_exists,is_php_fpm_process_exists,is_nginx_process_exists,is_httpd_process_exists,is_memcached_process_exists,is_mongodb_process_exists
from process import get_cron_path,get_sys_path,get_linux_distribution

from sys_services import get_server_status, query_server_config, change_server_start_type, set_server_status,delete_server,create_server,get_server_path

from ssh import get_sshd_port,get_sshd_pid_of_pidfile,get_sshd_pid_of_binfile,GetSSHStatus,get_sshd_status,get_firewall_status

from mysql import get_mysql_info,get_database_character,get_mysql_obj,CheckMyCnf
from cert import get_cert_data,query_dns,get_root_domain

from dict_obj import dict_obj
#rsa相关
from rsa import get_rsa_public_key,get_rsa_private_key,create_rsa_key,rsa_encrypt,rsa_decrypt,rsa_encrypt_for_private_key


#判断系统
if os.name == 'nt':
    from win_common import get_pip_list, get_run_python, get_run_pip, kill, ReadReg,DelReg,WriteReg
    from win_access import set_file_access, del_file_access, SetFileAccess
  
    from win_common import get_mode_and_user,set_mode,set_own,set_ownership
else:
    from linux_common import get_mode_and_user, set_mode,set_own,set_ownership
 

def init_msg():
    pass

def send_dingding():
    pass

def send_mail():
    pass

def GetHost(port=False):
    pass

def CheckCert(path= ""):
    if not path:
        path = get_panel_path() + '/ssl/certificate.pem'
    return get_cert_data(path)

def request_php(version, uri, document_root, method='GET', pdata=b''):
    pass

def is_free():
    pass

def load_module(module_name):
    pass

def get_ip():
    return GetLocalIp()

def trim(data):
    return data.replace(' ', '').strip()

def get_panel_log_file():
    return "{}/logs/error.log".format(get_panel_path())

# 将IP地址转换为整数
def ip2long(ip):
    ips = ip.split('.')
    if len(ips) != 4: return 0
    iplong = 2 ** 24 * int(ips[0]) + 2 ** 16 * int(ips[1]) + 2 ** 8 * int(ips[2]) + int(ips[3])
    return iplong

def long2ip(ips):
    i1 = int(ips / (2 ** 24))
    i2 = int((ips - i1 * (2 ** 24)) / (2 ** 16))
    i3 = int(((ips - i1 * (2 ** 24)) - i2 * (2 ** 16)) / (2 ** 8))
    i4 = int(((ips - i1 * (2 ** 24)) - i2 * (2 ** 16)) - i3 * (2 ** 8))
    return "{}.{}.{}.{}".format(i1, i2, i3, i4)

# 验证是否域名
def is_domain(domain):
    reg = "^([\w\-\*]{1,100}\.){1,10}([\w\-]{1,24}|[\w\-]{1,24}\.[\w\-]{1,24})$";
    if re.match(reg, domain): return True
    return False

def checkPort(port):
    return CheckPort(port)

# 搜索数据中是否存在
def inArray(arrays, searchStr):
    for key in arrays:
        if key == searchStr: return True
    return False

def return_message(status, message, data=None):
    if status in(0, "0"):
        status = True
    elif status in(-1, "-1"):
        status = False
    return returnMsg(status, data)

def lang(msg, *args):
    return msg.format(*args)

def GetLanguage():
    return "Simplified_Chinese"

def aes_encrypt(data, key):
    import panelAes
    if sys.version_info[0] == 2:
        aes_obj = panelAes.aescrypt_py2(key)
        return aes_obj.aesencrypt(data)
    else:
        aes_obj = panelAes.aescrypt_py3(key)
        return aes_obj.aesencrypt(data)

def aes_decrypt(data, key):
    import panelAes
    if sys.version_info[0] == 2:
        aes_obj = panelAes.aescrypt_py2(key)
        return aes_obj.aesdecrypt(data)
    else:
        aes_obj = panelAes.aescrypt_py3(key)
        return aes_obj.aesdecrypt(data)

def md5(strings):
    return Md5(strings)

def httpGet(url, timeout=60): 
    return HttpGet(url, timeout)

def httpPost(url, data, timeout=20):
    if timeout < 5: timeout = 5
    return HttpPost(url, data, timeout)

def readFile(filename, mode='r'):
    return ReadFile(filename, mode)

def writeFile(filename, s_body, mode='w+', encoding='utf-8'):
    return WriteFile(filename, s_body, mode, encoding)

# 读取文件二进制文件
def readFile2(filename, mode='r'):
    import os
    if not os.path.exists(filename): return False
    if not os.path.isfile(filename): return False

    fp = open(filename, mode)
    f_body = fp.read()
    fp.close()
    return f_body

# 写入字节文件内容
def writeFile2(filename, s_body, mode='w+'):
    try:
        fp = open(filename, mode)
        fp.write(s_body)
        fp.close()
        return True
    except:
        return False

def serviceReload():
    return ServiceReload()

def version():   
    try:
        version = readFile('{}/data/panel.version'.format(get_panel_path()))
    except:
        version = '6.0.0'
    return version

def getJson(data):
    return GetJson(data)

def returnJson(status, msg, args=()):
    return ReturnJson(status, msg, args)

def returnMsg(status, msg, args=()):
    return ReturnMsg(status, msg, args)

def getMsg(key, args=()):
    return GetMsg(key, args)

# 获取用户信息
def get_user_info():

    userInfo = {}
    user_file = '{}/data/userInfo.json'.format(get_panel_path())
    if not os.path.exists(user_file): 
        return userInfo
    try:
        userTmp = json.loads(readFile(user_file))    
        userInfo['uid'] = userTmp['uid']
        userInfo['access_key'] = userTmp['access_key']
        userInfo['username'] = userTmp['username']
        userInfo['serverid'] = userTmp['serverid']
        userInfo['oem'] = get_oem_name()
        userInfo['o'] = userInfo['oem']
        userInfo['mac'] = get_mac_address()
    except:
        pass
    return userInfo

def run_thread(fun, args=(), daemon=False):
    import threading
    p = threading.Thread(target=fun, args=args)
    p.setDaemon(daemon)
    p.start()
    return True

def bt_print(msg):
    try:
        print(msg)
    except:
        try:
            print(msg, msg.encode('utf-8'))
        except:pass

def print_log(msg):
    bt_print(msg)

def print_error():
    print_log(get_error_info(), 'ERROR')

def set_module_logs(mod_name,fun_name,count = 1):
    """
    @模块使用次数
    @mod_name 模块名称
    @fun_name 函数名
    """
    pass

# 加密密码字符
def hasPwd(password):
    import crypt
    return crypt.crypt(password, password)

def check_tcp(ip, port):
    import socket
    try:
        s = socket.socket()
        s.settimeout(5)
        s.connect((ip.strip(), int(port)))
        s.close()
    except:
        return False
    return True

def html_decode(text): 
    try:
        from cgi import html
        text2 = html.unescape(text)
        return text2
    except:
        return text

def loads_json(path):
    """
    从文件读取xml转为json对象
    @path 文件路径
    """
    data = {}
    try:
        import xmltodict
        conf = readFile(path)
        data = xmltodict.parse(conf)
    except:
        pass
    return data

def format_xml(conf):
    """
    格式化xml
    @conf 文件内容
    """
    from xml.dom import minidom

    b = minidom.parseString(conf)
    c = b.toprettyxml(indent="\t")
    return c

def dumps_json(conf):
    """
    json对象转为xml文件
    @conf json对象
    return str xml文件内容
    """
    xmlstr = xmltodict.unparse(conf)
    return xmlstr

 # 写入操作日志
def WriteLog(type, logMsg, args=()):
    uid = 1
    username = 'system'
    try:
        if 'login_address' in session:
            logMsg = '{} {}'.format(session['login_address'], logMsg)
    except:pass
    sql = db.Sql()
    mDate = time.strftime('%Y-%m-%d %X', time.localtime())
    data = (uid, username, type, logMsg, mDate)
    result = sql.table('logs').add('uid,username,type,log,addtime', data)

def get_page(count, p=1, rows=12, callback='', result='1,2,3,4,5,8'):
    """
    构造分页
    @count 总数量
    @p 当前第几页
    @rows 每页行数
    @callback 回调函数
    @result 构造结果
    """
    import page
    fullurl = "/"

    page = page.Page()
    info = {'count': count, 'row': rows, 'p': p, 'return_js': callback, 'uri': fullurl}
    data = {'page': page.GetPage(info, result), 'shift': str(page.SHIFT), 'row': str(page.ROW)}
    return data

def url_encode(data):
    if type(data) == str: return data
    import urllib
    if sys.version_info[0] != 2:
        pdata = urllib.parse.urlencode(data).encode('utf-8')
    else:
        pdata = urllib.urlencode(data)
    return pdata


def url_decode(data):
    if type(data) == str: return data
    import urllib
    if sys.version_info[0] != 2:
        pdata = urllib.parse.urldecode(data).encode('utf-8')
    else:
        pdata = urllib.urldecode(data)
    return pdata


def get_python_bin():
    """
    获取python二进制文件路径
    """
    if os.name == 'nt':
        return '"C:/Program Files/python/python.exe"'
    else:
        bin_file = '{}/pyenv/bin/python3'.format(get_panel_path())
        if not os.path.exists(bin_file):
            bin_file = '/usr/bin/python3'
        if not os.path.exists(bin_file):
            bin_file = '/usr/bin/python'
    return bin_file

def mod_reload(mode):
    """
    重载指定模块
    @mode 模块对象
    """
    if not mode: return False
    try:
        if sys.version_info[0] == 2:
            reload(mode)
        else:
            import imp
            imp.reload(mode)
        return True
    except:
        return False
        
def phpReload(version):
    # 重载PHP配置
    import os
    if os.path.exists(get_setup_path() + '/php/' + version + '/libphp5.so'):
        ExecShell('/etc/init.d/httpd reload')
    else:
        ExecShell('/etc/init.d/php-fpm-' + version + ' reload')
        ExecShell("/etc/init.d/php-fpm-{} start".format(version))


# 转码
def to_string(lites):
    if type(lites) != list: lites = [lites]
    m_str = ''
    for mu in lites:
        if sys.version_info[0] == 2:
            m_str += unichr(mu).encode('utf-8')
        else:
            m_str += chr(mu)
    return m_str

#  将dict转换为dict_obj
def to_dict_obj(data):
    pdata = dict_obj()
    for key in data.keys():
        pdata[key] = data[key]
    return pdata


class session_obj:
    def __contains__(self, key):
        return getattr(self,key,None)
    def __setitem__(self, key, value):
        setattr(self, key, value)
        cache.set(key, value,86400)
    def __getitem__(self, key):
        return cache.get(key)
    def __delitem__(self,key): cache.delete(key)
    def __delattr__(self, key): cache.delete(key)

try:
    import FileCache
    cache = FileCache.FileCache()

    import FileSession
    session = FileSession.FileSession(session_expiry=86400)
except:
    cache = None
    session = None


def cache_get(key):

    if not cache: return None
    return cache.get(key)

def cache_set(key, value, timeout=86400):
    if not cache: return False
    return cache.set(key, value, timeout)