# coding: utf-8


def get_sshd_port():
    '''
        @name 获取sshd端口
        @author hwliang
        @return int
    '''
    # 先尝试从进程中获取当前实际的监听端口
    sshd_port = 22
    is_ok = 0
    pid = get_sshd_pid_of_pidfile()
    if not pid: pid = get_sshd_pid_of_binfile()
    if pid:
        try:
            import psutil
            p = psutil.Process(pid)
            for conn in p.connections():
                if conn.status == 'LISTEN':
                    sshd_port = conn.laddr[1]
                    is_ok = 1
                    break
        except:
            pass

    # 如果从进程获取失败，则尝试从配置文件获取
    if not is_ok: sshd_port = GetSSHPort()

    return sshd_port


def get_sshd_pid_of_pidfile():
    '''
        @name 通过PID文件获取SSH状态
        @author hwliang
        @return int 0:关闭 pid:开启
    '''
    sshd_pid_list = ['/run/sshd.pid', '/var/run/sshd.pid', '/run/ssh.pid', '/var/run/ssh.pid']
    sshd_pid_file = None
    for spid_file in sshd_pid_list:
        if os.path.exists(spid_file):
            sshd_pid_file = spid_file
            break

    if sshd_pid_file:
        sshd_pid = readFile(sshd_pid_file)
        if not sshd_pid: return 0
        try:
            sshd_pid = int(sshd_pid)
            if not sshd_pid: return 0
            if pid_exists(sshd_pid):
                return sshd_pid
        except:
            pass
    return 0


def get_sshd_pid_of_binfile():
    '''
        @name 通过执行文件获取SSH状态
        @author hwliang
        @return int 进程pid
    '''
    sshd_bin_list = ['/usr/sbin/sshd', '/usr/bin/sshd', '/usr/sbin/ssh', '/usr/bin/ssh']
    sshd_bin = None
    pid = 0
    for sbin in sshd_bin_list:
        if os.path.exists(sbin):
            sshd_bin = sbin
            break

    if sshd_bin:
        pid = get_process_pid(sshd_bin.split('/')[-1], sshd_bin, '-D')

    return pid



def get_firewall_status():
    '''
        @name 获取系统防火墙状态
        @author hwliang
        @return int 0.关闭 1.开启 -1.未安装
    '''
    import psutil
    firewall_files = {'/usr/sbin/firewalld': "pid", '/usr/bin/firewalld': "pid",
                      '/usr/sbin/ufw': "/usr/sbin/ufw status|grep 'Status: active'",
                      '/sbin/ufw': "/sbin/ufw status |grep 'Status: active'",
                      '/usr/sbin/iptables': "service iptables status|grep 'Chain INPUT'"}
    for f in firewall_files.keys():
        if not os.path.exists(f): continue
        _cmd = firewall_files[f]
        if _cmd != "pid":
            res = ExecShell(_cmd)
            if res[0].strip():
                return 1
            else:
                return 0
        for pid in psutil.pids():
            try:
                p = psutil.Process(pid)
                if f in p.cmdline():
                    return 1
            except:
                pass
        return 0
    return -1

def GetSSHStatus():
    '''
        @name 获取SSH状态
        @author hwliang
        @return bool
    '''
    if get_sshd_pid_of_pidfile():
        return True
    elif get_sshd_pid_of_binfile():
        return True
    return False


def get_sshd_status():
    '''
        @name 获取SSH状态
        @author hwliang
        @return bool
    '''
    return GetSSHStatus()
