# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )
    Lang-Print -Msg "ڰװ {}:{}" -Arguments @("Apache",$Version)

    Invoke-Cmd -Command "net stop http /y"    
    Set-Service -Name W3SVC -StartupType Disabled

    # жϷǷ
    if (Get-Service -Name apache -ErrorAction SilentlyContinue) {
        Lang-Print -Msg "{} Ѵڣ׼ж" -Arguments @("Apache")
        Set-WebServer-Status -Status "stop"
        Delete-Panel-Service -ServiceName "apache"
    }
    #  Apache װ·
    $apache_dir_path = "$SOFT_PATH/apache"
    if (-not (Test-Path $apache_dir_path)) {
        New-Item -Path $apache_dir_path -ItemType Directory -Force
    }

    $DownUrl = "$DownNode/win/apache_new/apache$Version.zip"
    $apache_package_path = "$SOFT_PATH/temp/apache.zip"

    if (-not (Download-File -Url $DownUrl -OutputPath $apache_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("Apache")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("Apache")
    Un-Zip -FilePath $apache_package_path -DestinationPath $SOFT_PATH

    $conf_file = "$apache_dir_path/conf/httpd.conf"
    if (Test-Path $conf_file) {
        $conf_body = Get-Content -Path $conf_file -Raw
        $conf_body = $conf_body -replace "\[PATH\]", $apache_dir_path
        Set-Content -Path $conf_file -Value $conf_body
    }

    Invoke-Cmd -Command "$apache_dir_path/bin/httpd.exe -k install -n apache "
    Start-Service -Name apache

    Lang-Print -Msg "{} װɹ" -Arguments @("Apache")
    Write-Host "Successfully"
}

#
function Upgrade() {
    param (
        [string]$Version
    )
    Lang-Print -Msg " {}" -Arguments @("Apache")

    Set-WebServer-Status -Status "stop"

    $conf_file = "$SOFT_PATH/apache/conf/httpd.conf"
    Back-ConfigFile -FilePath $conf_file
    
    Install -Version $Version
    Restore-ConfigFile -FilePath $conf_file

    Start-Service -Name apache
    Lang-Print -Msg "{} ɹ" -Arguments @("Apache")
}

function UnInstall {
    Lang-Print -Msg "{} ж" -Arguments @("Apache")

    Stop-Service -Name apache -Force    
    Delete-Panel-Service -ServiceName "apache"

    Lang-Print -Msg "{} жسɹ" -Arguments @("Apache")
}


switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall
    }
}
