
# ȫֱ
$ROOT_PATH =  $env:BT_PANEL -replace "\\", "/"
$SOFT_PATH = $env:BT_SETUP -replace "\\", "/"
$ConfigFile =  "$ROOT_PATH/config/config.json"

$DownNode = "http://download.bt.cn"  # صַ

function Get-File-Content {
    param (
        [string]$FilePath
    )
    try {
       return Get-Content -Path $FilePath -Raw -Encoding UTF8 -ErrorAction Stop
    } catch {            
       return Get-Content $FilePath 
    }   
}

$bodyStr = Get-File-Content -FilePath $ConfigFile
# ļ
$conf = $bodyStr | ConvertFrom-Json
if (-not $conf.language -or $conf.language -eq "" -or $conf.language -eq "Simplified_Chinese") {
    $conf.language = "zh"  # Ĭ
}

# ļ
$LangFile = "$ROOT_PATH/languages/$($conf.language)/server.json"
if (-not (Test-Path $LangFile)) {
    Write-Host "Language file not found: $LangFile"
    exit
}
$langBody = Get-File-Content -FilePath $LangFile
$langObject = $langBody | ConvertFrom-Json

function Lang-Print {
    param (
        [string]$Msg,           # Ϣ
        [array]$Arguments       # 
    )
	
    $res = Lang-Ctx -Msg $Msg -Arguments $Arguments
    Write-Host $res
}

function Is-MD5 {
    param (
        [string]$InputString  # Ҫַ
    )
    #  MD5 ʽ
    $md5Regex = '^[a-fA-F0-9]{32}$'
    # ַǷƥ MD5 ʽ
    if ($InputString -match $md5Regex) {
        return $true
    } else {
        return $false
    }
}

# 庯ȡ
function Lang-Ctx {
    param (
        [string]$Msg,           # Ϣ
        [array]$Arguments            # 
    )

    if (Is-MD5 -InputString $Msg) {
        $Md5Hash = $Msg
    } else {
        $Md5Hash = Get-MD5Hash -InputString ($Msg -replace " ", "")
    }  

    $value = $langObject.$Md5Hash 
    if (-not $value) {
        $value = $Msg
    }
    return Replace-LangVar -Msg $value -Arguments $Arguments
}

function Replace-LangVar {
    param (
        [string]$msg,
        [array]$Arguments
    )

    if ($Arguments.Count -eq 0) {
        return $msg
    }

    # ݵͰ汾 PowerShell
    $sb = New-Object System.Text.StringBuilder($msg)
    $replaceCount = 0

    foreach ($arg in $Arguments) {
        $index = $sb.ToString().IndexOf('{}')
        if ($index -eq -1) { break }
        [void]$sb.Remove($index, 2)
        [void]$sb.Insert($index, $arg)
        $replaceCount++
    }

    return $sb.ToString()
}


function Get-MD5Hash {
    param (
        [string]$InputString  
    )
    $md5 = [System.Security.Cryptography.MD5]::Create()
    $bytes = [System.Text.Encoding]::UTF8.GetBytes($InputString)
    $hashBytes = $md5.ComputeHash($bytes)
    $hashString = [BitConverter]::ToString($hashBytes) -replace "-", ""
    return $hashString.ToLower()
}


function Invoke-Cmd {
    param([string]$Command)
    cmd /c "$Command" 
}

function Invoke-Cmd-NoOut {
    param([string]$Command)
  
    cmd /c "$Command" > $null 2>&1
}

function Install-Service {
    param (
        [string]$ServiceName,  # 
        [string]$DisplayName,   # ʾ
        [string]$BinaryPathName,      # ִļ·
        [string]$Description = ""  # ѡ
    )
  
    Lang-Print -Msg "ڰװ {} " -Arguments @($ServiceName)
    New-Service -Name $ServiceName -BinaryPathName $BinaryPathName -DisplayName $DisplayName -Description $Description -StartupType Automatic

    # Ƿװɹ
    $service = Get-Service -Name $ServiceName -ErrorAction SilentlyContinue
    if ($null -eq $service) {
        Lang-Print -Msg " {} װʧ" -Arguments @($ServiceName)
        return $false
    }
    Lang-Print -Msg " {} װɹ" -Arguments @($ServiceName)
    return $true
}

#ļ
function Download-File {
    param (
        [string]$Url,          # 
        [string]$OutputPath    # ·
    )
    try {
        #жļǷڣҪɾ
        if (Test-Path $OutputPath) {
            Remove-Item $OutputPath -Force
        }
        $wget_file =  "$ROOT_PATH/script/wget.exe"
        if (-not (Test-Path $wget_file)) {
            Invoke-WebRequest -Uri $Url -OutFile $OutputPath -ErrorAction Stop          
        }else{
            Invoke-Cmd -Command "$wget_file -c -O `"$OutputPath`" `"$Url`""
        }       
       
        if (-not (Test-Path $OutputPath)) {
            Lang-Print -Msg "ʧܣļδҵ: {}" -Arguments @($OutputPath)
            return $false
        }
        # ļСǷ0
        $fileInfo = Get-Item $OutputPath
        if ($fileInfo.Length -le 0) {
            Lang-Print -Msg "ʧܣļСΪ0: {}" -Arguments @($OutputPath)
            Remove-Item $OutputPath -Force
            return $false
        }
        Lang-Print -Msg "سɹ: {}" -Arguments @($OutputPath)
        return $true
    } catch {
        Lang-Print -Msg "ʧ: {}" -Arguments @("$_")
        return $false
    }
}

function Generate-RandomString {
    param(
        [int]$Length = 16  # ַ
    )
    #  GUID ȥ "-"
    $guid = ([guid]::NewGuid().ToString() -replace "-")

    # ȡָ
    return $guid.Substring(0, $Length)
}

#ѹzipļ
function Un-Zip {
    param (
        [Parameter(Mandatory=$true)]
        [string]$FilePath,          # ZIPļ·
        
        [Parameter(Mandatory=$true)]
        [string]$DestinationPath,   # ѹĿ·
        
        [switch]$Quiet,              # Ĭģʽʾȣ
        [switch]$Force              # ǿƸļ       
    )
    # unzip.exe
    $unzip_exe =  "$SOFT_PATH/panel/script/unzip.exe"
    if (Test-Path $unzip_exe) {     
        #unzipѹļָĿ¼ѹʱ
        $arguments = "-o `"$FilePath`" -d `"$DestinationPath`""       
        Invoke-Cmd "$unzip_exe $arguments"
        return $true      
    }
    try {
        # ĿĿ¼ڣ
        if (-not (Test-Path -Path $DestinationPath)) {
            New-Item -ItemType Directory -Path $DestinationPath -Force | Out-Null
        }

        # Shell COM
        $shell = New-Object -ComObject Shell.Application
        
        # ȡZIPļĿļж
        $zipFile = $shell.NameSpace((Get-Item $FilePath).FullName)
        $destFolder = $shell.NameSpace((Get-Item $DestinationPath).FullName)

        # ýѹѡλ룩
        $options = 0
        
        # 4 = ʾȷ϶Ի
        if ($Force) { $options += 4 }
        
        # 16 = ʾȶԻĬʾ
        if (-not $Quiet) { $options += 16 }
                 
        # 1024 = ʾԻ
        if ($Quiet) { $options += 1024 }

        # ִнѹ
        $destFolder.CopyHere($zipFile.Items(), $options)

        # ͷCOMԴ
        [System.Runtime.Interopservices.Marshal]::ReleaseComObject($destFolder) | Out-Null
        [System.Runtime.Interopservices.Marshal]::ReleaseComObject($zipFile) | Out-Null
        [System.Runtime.Interopservices.Marshal]::ReleaseComObject($shell) | Out-Null
        [System.GC]::Collect()
        [System.GC]::WaitForPendingFinalizers()
                
    }
    catch {
      
        return $false
    }    
    return $true
}

function Get-AppSetup {
    param (  
        [array]$SearchList   # ؼ
    )
    $uninstallPath = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
    if ([Environment]::Is64BitOperatingSystem) {
        $uninstallPath = "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall"
    }
    try {
        $key = Get-ChildItem -Path $uninstallPath
        foreach ($subKey in $key) {
            try {
                # ȡ DisplayName ֵ
                $displayName = (Get-ItemProperty -Path $subKey.PSPath -Name "DisplayName" -ErrorAction SilentlyContinue).DisplayName
                if (-not $displayName) { continue }

                # Ƿƥ
                $matchCount = 0
                foreach ($name in $SearchList) {
                    if ($displayName -like "*$name*") {
                        $matchCount++
                    } else {
                        $matchCount = 0
                    }
                }
                # ƶƥ䣬򷵻 True
                if ($matchCount -eq $SearchList.Count) {
                    return $true
                }
            } catch {
                continue
            }
        }
    } catch {
        Lang-Print -Msg "޷ע·: {}" -Arguments @("$uninstallPath")
    }
    return $false
}

function Setup-VCRedist {
    param (
        [string]$VcVersion # VC++ 汾 "2008", "2010", "2012", "2013", "2015", "2017", "2019", "2022"
    )
    $bit = if ([Environment]::Is64BitOperatingSystem) { "x64" } else { "x86" }
    $vc_list = @("2015","2017", "2019","2022")
    if ($vc_list -contains $VcVersion) {
      
        if (@("2015","2017", "2019") -contains $VcVersion) {
            if  (Get-AppSetup -SearchList @("Visual C++", "2015-2019",$bit)) {
                Lang-Print -Msg "{} пѰװ" -Arguments @("VC++ 2015-2019")
                return $true
            }
        }
        if  (Get-AppSetup -SearchList @("Visual C++", "2015-2022",$bit)) {
            Lang-Print -Msg "{} пѰװ" -Arguments @("VC++ 2015-2022")
            return $true
        }
    }

    if  (Get-AppSetup -SearchList @("Visual C++", $VcVersion,$bit)) {
        Lang-Print -Msg "{} пѰװ" -Arguments @("VC++ $VcVersion")
        return $true
    }

    # زװ VC++ п
    $installerPath = "$SOFT_PATH/temp/vcredist_$VcVersion.exe"  
    Lang-Print -Msg " {} п" -Arguments @("VC++ $VcVersion")

    Write-Host $bit
    $DownUrl = "$DownNode/win/vc/vcredist_$VcVersion" + "_$bit.exe"
    if (-not (Download-File -Url $DownUrl -OutputPath $installerPath)) {
        Lang-Print -Msg " {} пʧ" -Arguments @("VC++ $VcVersion")
        return $false
    }
    Lang-Print -Msg "ڰװ {} п⣬Ժ..." -Arguments @("VC++ $VcVersion")

    Write-Host "$installerPath /quiet /norestart"
    Invoke-Cmd -Command "$installerPath /quiet /norestart"

    #¼
    if  (Get-AppSetup -SearchList @("Visual C++", $VcVersion,$bit)) {
        return $true
    }
    Lang-Print -Msg "{} пⰲװʧ" -Arguments @("VC++ $VcVersion")
    return $false
}

#ɾа汾ļ
function Remove-VersionFiles {
    param (
        [string]$Path
    )
    $default_list = @('version.pl', 'version.txt', 'version.json', 'version.xml')
    foreach ($file in $default_list) {
        $file_path = "$Path/$file"
        if (Test-Path $file_path) {
            Remove-Item -Path $file_path -Force -ErrorAction SilentlyContinue          
        }
    }
}


function Get-PanelFile {
    $default_list = @('btPanel.exe', "aaPanel.exe")
    foreach ($file in $default_list) {
        $file_path = "$ROOT_PATH/$file"
        if (Test-Path $file_path) {
            return $file_path
        }
    }
    return ""
}

function Set-FileAccess {
    [CmdletBinding(SupportsShouldProcess = $true)]
    param (
        [Parameter(Mandatory = $true)]
        [ValidateScript({ Test-Path $_ -PathType Any })]
        [string]$Path,          # ļĿ¼·
        
        [Parameter(Mandatory = $true)]
        [ValidateNotNullOrEmpty()]
        [string]$User,          # ûû
        
        [Parameter(Mandatory = $true)]
        [ValidateSet("Modify", "Read", "Full")]
        [string]$Permission,    # Ȩ
        
        [bool]$Recursive = $false  # ǷݹȨ
    )

    # Ȩӳ
    $permissionMap = @{
        "Modify" = "M"
        "Read"   = "R"
        "Full"   = "F"
    }

    # ȡȨޱ־
    $permissionFlag = $permissionMap[$Permission]
    
    # ݹ
    $recursiveFlag = if ($Recursive) { "/T" } else { $null }
    
    # icacls
    $icaclsArgs = @(
        "`"$Path`""
        $recursiveFlag
        "/grant"
        "`"${User}:${permissionFlag}`""
        "/Q"  # ģʽ
        "/C"  # ʹ
    ) | Where-Object { $_ -ne $null }

    if ($PSCmdlet.ShouldProcess($Path, " $Permission Ȩ޸ $User")) {
        try {
            # ʹStart-ProcessInvoke-Expressionȫ
            $process = Start-Process "icacls" -ArgumentList $icaclsArgs -NoNewWindow -Wait -PassThru -RedirectStandardOutput "nul"
            
            if ($process.ExitCode -eq 0) {
                Lang-Ctx -Msg "ɹ {}  {}  {} Ȩ" -Arguments @($User, $Path, $Permission)
                return $true
            } 
            else {
                $errorMsg = switch ($process.ExitCode) {
                    1 { Lang-Ctx -Msg "ЧȨ޲" -Arguments @() }
                    2 { Lang-Ctx -Msg "ļδҵ" -Arguments @() }
                    4 { Lang-Ctx -Msg "̿ռ䲻" -Arguments @() }
                    5 { Lang-Ctx -Msg "ʱܾ" -Arguments @() }
                    default { Lang-Ctx -Msg "δ֪ " -Arguments @() }
                }
                throw Lang-Ctx -Msg "Ȩʧ: {}" -Arguments @($errorMsg)
            }
        }
        catch {
            Lang-Ctx -Msg "Ȩòʧ: {}" -Arguments @($_.Exception.Message)
            return $false
        }
    }
}

function Back-ConfigFile {
    param (
        [string]$FilePath
    )
    if (Test-Path $FilePath) {
        $backupFile = "$FilePath.backup"
        Copy-Item -Path $FilePath -Destination $backupFile -Force
        Lang-Ctx -Msg "ѱļ: {}" -Arguments @($backupFile)
    } else {
        Lang-Ctx -Msg "ļ: {}" -Arguments @($FilePath)
    }
}
#ԭ
function Restore-ConfigFile {
    param (
        [string]$FilePath
    )
    $backupFile = "$FilePath.backup"
    if (Test-Path $backupFile) {
        Copy-Item -Path $backupFile -Destination $FilePath -Force
        Remove-Item -Path $backupFile -Force
        Lang-Ctx -Msg "ѻԭļ: {}" -Arguments @($FilePath)
    } else {
        Lang-Ctx -Msg "ļ: {}" -Arguments @($backupFile)
    }
}

function Set-WebServer-Status {
    
    param (
        [string]$Status
    )
    $process_list = @("httpd.exe", "nginx_server.exe","nginx.exe","w3wp.exe","php-cgi.exe")
    foreach ($process_name in $process_list) {    
        #ǿƽ
        Invoke-Cmd-NoOut -Command "taskkill /f /im $process_name"      
    }    
    $webServer = ""
    #webǷװ,nginx/apache/iis
    if (Get-Service -Name nginx -ErrorAction SilentlyContinue){
        $webServer = "nginx"
    }elseif (Get-Service -Name apache -ErrorAction SilentlyContinue){
        $webServer = "apache"
    }elseif (Get-Service -Name w3svc -ErrorAction SilentlyContinue){
        $webServer = "iis"
    }

    if ($Status -eq "start") {
        Start-Service -Name $webServer     
    } elseif ($Status -eq "stop") {
        Stop-Service -Name $webServer
    }
    elseif ($Status -eq "restart") {
        Restart-Service -Name $webServer
    } 
}

function Delete-Panel-Service {
    param (
        [string]$ServiceName
    )
    try {
        if (Get-Service -Name $ServiceName -ErrorAction SilentlyContinue) {
            Stop-Service -Name $ServiceName -Force
            Invoke-Cmd -Command "sc delete $ServiceName"
            Remove-Item -Path "HKLM:\SYSTEM\CurrentControlSet\Services\$ServiceName" -Recurse -Force -ErrorAction SilentlyContinue
            Remove-Item -Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$ServiceName" -Recurse -Force -ErrorAction SilentlyContinue
            Remove-Item -Path "HKLM:\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\$ServiceName" -Recurse -Force -ErrorAction SilentlyContinue
            Remove-Item -Path "HKLM:\SYSTEM\CurrentControlSet\Services\EventLog\Application \$ServiceName" -Recurse -Force -ErrorAction SilentlyContinue
            Remove-Item -Path "HKLM:\SYSTEM\CurrentControlSet\Services\EventLog\Application\$ServiceName" -Recurse -Force -ErrorAction SilentlyContinue
            Lang-Print -Msg "{} ɾ" -Arguments @($ServiceName)
        } else {
            Lang-Print -Msg "{} 񲻴" -Arguments @($ServiceName)
        }
    } catch {
        Lang-Print -Msg "ɾ {} ʧ: {}" -Arguments @($ServiceName, $_.Exception.Message)
    }
}