# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 

$FtpServiceName = "FileZilla Server"

function Install {
    param (
        [string]$Version
    )

    #жϷǷ
    if (Get-Service -Name $FtpServiceName -ErrorAction SilentlyContinue) {
        Lang-Print -Msg "{} Ѵڣ׼ж" -Arguments @($FtpServiceName)
        Invoke-Cmd -Command "sc stop `"$FtpServiceName`""
        Invoke-Cmd -Command "sc delete `"$FtpServiceName`""
    }

    $ftp_dir_path = "$SOFT_PATH/ftpServer"
    Lang-Print -Msg "ڰװ {}: {}" -Arguments @($FtpServiceName, $Version)

    #  FTP װ·
    $ftp_package_path =  "$SOFT_PATH/temp/ftpServer.zip"
    $DownUrl = "$DownNode/win/ftpServer.zip"
    if (-not (Download-File -Url $DownUrl -OutputPath $ftp_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("FTP")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("FTP")
    # ѹ FTP װ
    Un-Zip -FilePath $ftp_package_path -DestinationPath $SOFT_PATH
    
    Lang-Print -Msg "ڰװ{} " -Arguments @($FtpServiceName)
    $BinaryPathName = "`"$ftp_dir_path/FileZilla_Server.exe`""
    if (Install-Service -ServiceName $FtpServiceName -BinaryPathName $BinaryPathName -DisplayName "FileZilla Server" -Description "FileZilla FTP Server") {
        Lang-Print -Msg "{} װɹ" -Arguments @($FtpServiceName)
    } else {
        Lang-Print -Msg "{} װʧ" -Arguments @($FtpServiceName)
        return
    }
    Remove-VersionFiles -Path $ftp_dir_path
    $version  = (Get-Item "$ftp_dir_path/FileZilla_Server.exe").VersionInfo.FileVersion

    $version_parts = $version -split ','
    if ($version_parts.Count -ge 3) {
        $major = $version_parts[0]
        $minor = $version_parts[1]
        $build = $version_parts[2]
        $version = "$major.$minor.$build"
        $version = $version -replace ' ', ''
    }
    #д汾
    $version_file = "$ftp_dir_path/version.pl"
    if (-not (Test-Path -Path $version_file)) {
        New-Item -Path $version_file -ItemType File -Force | Out-Null
    }
    Set-Content -Path $version_file -Value $version -Force

    #  FTP 
    Start-Service -Name $FtpServiceName
    Write-Host "Successfully"
}

function UnInstall {
    Lang-Print -Msg "ж:{}" -Arguments @("FTP")

    # ֹͣ FTP 
    if (Get-Service -Name $FtpServiceName -ErrorAction SilentlyContinue) {
        Stop-Service -Name $FtpServiceName -Force
        Set-Service -Name $FtpServiceName -StartupType Disabled
    }

    # ɾ FTP    
    Invoke-Cmd -Command "sc delete `"$FtpServiceName`""

    Lang-Print -Msg "ж:{}" -Arguments @("FTP")
}

function Upgrade() {
    param (
        [string]$Version
    )
    Lang-Print -Msg " {}" -Arguments @($FtpServiceName)

    if (Get-Service -Name $FtpServiceName -ErrorAction SilentlyContinue) {
        Stop-Service -Name $FtpServiceName -Force
    }

    $conf_file = "$SOFT_PATH/ftpServer/FileZilla Server.xml"
    Back-ConfigFile -FilePath $conf_file

    Install -Version $Version

    Restore-ConfigFile -FilePath $conf_file
    Start-Service -Name $FtpServiceName

}

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall
    }    
}
