# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 

$Appcmd = Join-Path $env:windir "system32\inetsrv\appcmd.exe"
# װ
function Install {
    param (
        [string]$Version
    )
    Lang-Print -Msg "˽ȳ10ӣҪֶװIISֶװҪٰͨװһΣ·°װ" -Arguments @("")
    # ִ pkgmgr װ IIS 
    Lang-Print -Msg "ڰװ IIS Ժ..." -Arguments @("")
    Start-Process -FilePath "cmd.exe" -ArgumentList "/c start /w pkgmgr /iu:IIS-WebServerRole;IIS-WebServer;IIS-CommonHttpFeatures;IIS-StaticContent;IIS-DefaultDocument;IIS-DirectoryBrowsing;IIS-HttpErrors;IIS-HttpRedirect;IIS-ApplicationDevelopment;IIS-ASP;IIS-CGI;IIS-ISAPIExtensions;IIS-ISAPIFilter;IIS-ServerSideIncludes;IIS-HealthAndDiagnostics;IIS-HttpLogging;IIS-LoggingLibraries;IIS-RequestMonitor;IIS-HttpTracing;IIS-CustomLogging;IIS-ODBCLogging;IIS-Security;IIS-BasicAuthentication;IIS-WindowsAuthentication;IIS-DigestAuthentication;IIS-ClientCertificateMappingAuthentication;IIS-IISCertificateMappingAuthentication;IIS-URLAuthorization;IIS-RequestFiltering;IIS-IPSecurity;IIS-Performance;IIS-HttpCompressionStatic;IIS-HttpCompressionDynamic;IIS-WebServerManagementTools;IIS-ManagementScriptingTools;IIS-ASPNET;IIS-NetFxExtensibility;IIS-ManagementService;IIS-ManagementConsole;IIS-IIS6ManagementCompatibility; /norestart" -Wait -NoNewWindow

    Set-Service -Name W3SVC -StartupType Automatic
    Start-Service -Name W3SVC -ErrorAction Stop

    # ޸ HTTP 
    try {
        Set-ItemProperty -Path "HKLM:\SYSTEM\CurrentControlSet\Services\HTTP" -Name "Start" -Value 3 -Type DWord
    } catch {
        Lang-Print -Msg "޷޸ HTTP : {}" -Arguments @($_)
    }

    #жϷ״̬
    $service = Get-Service -Name w3svc -ErrorAction SilentlyContinue
    if ($null -eq $service) {
        Lang-Print -Msg "IIS δװδȷװ" -Arguments @()
        exit 1
    }
    if ($service.Status -ne 'Running') {
        Lang-Print -Msg ":{}" -Arguments @("IIS")
        Start-Service -Name w3svc
    } else {
        Lang-Print -Msg "IIS " -Arguments @()
    }

    # Ŀ¼
    $log_dir = Join-Path $SOFT_PATH "wwwlogs"
    if (-not (Test-Path $log_dir)) {
        New-Item -Path $log_dir -ItemType Directory | Out-Null
    }
    Invoke-AppCmd -Command "set config -section:system.applicationHost/sites /siteDefaults.logFile.directory:\"$log_dir\" /commit:apphost"

    Lang-Print -Msg "Asp" -Arguments @("")
    Invoke-AppCmd -Command "set config /section:asp /enableParentPaths:True /commit:apphost"
    Invoke-AppCmd -Command "set config -section:anonymousAuthentication /userName:`"`" /commit:apphost"

    Lang-Print -Msg ".Net3.5(2-3)" -Arguments @("")
    Invoke-Cmd-NoOut -Command "DISM /Online /Enable-Feature /FeatureName:NetFx3 /n"
    Invoke-Cmd-NoOut -Command "DISM /Online /Enable-Feature /all /FeatureName:NetFx3 /n"

    Invoke-Cmd-NoOut -Command "DISM /online /enable-feature /all /featurename:IIS-ASPNET45 /n"

    Lang-Print -Msg "ŻiisĬҳ" -Arguments @("")
    $default_list = @('default.html', 'default.asp', 'default.aspx', 'index.php', 'index.asp', 'index.aspx')
    foreach ($key in $default_list) {
       Invoke-AppCmd-NoOut -Command "set config /section:defaultDocument /+files.[value='$key']"
    }

    try {
        $iisRegPath = "HKLM:\SOFTWARE\Microsoft\InetStp"
        $iisVersion = (Get-ItemProperty -Path $iisRegPath -Name "MajorVersion").MajorVersion
        if ($iisVersion -gt 9) {
            Set-ItemProperty -Path $iisRegPath -Name "MajorVersion" -Value 9
        }
    } catch {
        Lang-Print -Msg "޷ʻ޸ע: {}" -Arguments @($_)
    }

    #iis.setup
    $conf_file = Join-Path $ROOT_PATH "data/iis.setup"
    if (-not (Test-Path $conf_file)) {
        New-Item -Path $conf_file -ItemType File | Out-Null
    }

    Set-URLRewrite
    Set-Proxy
    Set-Php

    Configure-IIS


    Write-Host "Successfully"
}


function Configure-IIS {

    Lang-Print -Msg " IIS" -Arguments @("")
    Invoke-AppCmd -Command "unlock config -section:system.webServer/handlers"

    Lang-Print -Msg "ע" -Arguments @("")
    regsvr32 /u /s "$env:windir\system32\wshom.ocx"
    regsvr32 /u /s "$env:windir\system32\shell32.dll"


    Lang-Print -Msg "Ż IIS" -Arguments @("")
    Invoke-AppCmd -Command "set config /section:system.webServer/serverRuntime /appConcurrentRequestLimit:100000"

    try {
        Lang-Print -Msg "޸עŻ HTTP " -Arguments @("")
        Set-ItemProperty -Path "HKLM:\System\CurrentControlSet\Services\HTTP\Parameters" -Name "MaxConnections" -Value 100000 -Type DWord
        Set-ItemProperty -Path "HKLM:\System\CurrentControlSet\Services\HTTP\Parameters" -Name "MaxFieldLength" -Value 32768 -Type DWord
        Set-ItemProperty -Path "HKLM:\System\CurrentControlSet\Services\HTTP\Parameters" -Name "MaxRequestBytes" -Value 32768 -Type DWord
    } catch {
        Lang-Print -Msg "޸עʧ: {}" -Arguments @($_)
    }
    #  Windows ֤
    Invoke-AppCmd-NoOut -Command "set config -section:system.webServer/security/authentication/windowsAuthentication /enabled:true"
    # þ̬
    Lang-Print -Msg "þ̬" -Arguments @("")
    Invoke-AppCmd-NoOut -Command "set config /section:staticContent /+[fileExtension='.',mimeType='text/plain']"

    Invoke-Cmd-NoOut -Command "DISM /online /enable-feature /featurename:IIS-ASPNET45"
    Invoke-Cmd-NoOut -Command "DISM /online /enable-feature /all /featurename:IIS-ASPNET45"

    #עе.netiis
    $net_versions = @(
        "$env:windir\Microsoft.NET\Framework\v2.0.50727",
        "$env:windir\Microsoft.NET\Framework\v4.0.30319",
        "$env:windir\Microsoft.NET\Framework64\v2.0.50727",
        "$env:windir\Microsoft.NET\Framework64\v4.0.30319"
    )
    foreach ($net_path in $net_versions) {
        if (Test-Path $net_path) {
            $exe = Join-Path $net_path "aspnet_regiis.exe"
            if (Test-Path $exe) {
                Lang-Print -Msg "ע $exe  IIS" -Arguments @("")
                Start-Process -FilePath $exe -ArgumentList "-i" -Wait -NoNewWindow
            }
        }
    }

    #  IIS
    Lang-Print -Msg " IIS" -Arguments @("")
    iisreset /start
}

#α̬չ
function Set-URLRewrite {

    $Url =  "$DownNode/win/URLRewrite_x64.msi"  
    $localPath =  "$SOFT_PATH/temp/URLRewrite.msi"    

    Lang-Print -Msg "ڰװ URLRewrite" -Arguments @("")

    if (-not (Download-File -Url $Url -OutputPath $localPath)) {
        Write-Host " URLRewrite ʧ"
        return
    }

    Start-Process -FilePath $localPath -ArgumentList "/qb" -Wait -ErrorAction Stop 
}

#չ
function Set-Proxy{
        
    $Url = "$DownNode/win/panel/data/requestRouter_x64.msi"  # 滻Ϊʵʵصַ
    $localPath =  "$SOFT_PATH/temp/requestRouter.msi"       # صʱĿ¼

    Lang-Print -Msg "ڰװ RequestRouter" -Arguments @("")
    if (-not (Download-File -Url $Url -OutputPath $localPath)) {
        Write-Host " RequestRouter ʧ"
        return
    }

    Start-Process -FilePath $localPath -ArgumentList "/qb" -Wait -ErrorAction Stop
    Invoke-AppCmd "set config /section:proxy /enabled:true /httpVersion:PassThrough /keepAlive:true /timeout:0.00:02:00 /reverseRewriteHostInResponseHeaders:true /xForwardedByHeader:X-Forwarded-Host /xForwardedForHeaderName:X-Forwarded-For /includePortInXForwardedFor:true /minResponseBuffer:256 /maxResponseHeaderSize:65536 /proxy: /proxyBypass: /cache.enabled:true /cache.validationInterval:0.00:01:00 /commit:apphost"
}

# iis׷PHPչ
function Set-Php{
    
    #жw3svcǷװ
    if (-not (Get-Service -Name w3svc -ErrorAction SilentlyContinue)) {      
        return
    }
  
    # ѭ
    for ($x = 0; $x -le 15; $x++) {
        Invoke-AppCmd-NoOut "set config /section:system.webServer/fastCGI /-[InstanceMaxRequests='10000']"
        Invoke-AppCmd-NoOut "set config /section:system.webServer/handlers /-[path='*.php']"
    }
    #  PHP װ·
    $php_dir_path = Join-Path $SOFT_PATH "php"

    #  PHP Ŀ¼
    $phpDirs = Get-ChildItem -Path $php_dir_path -Directory
    foreach ($dir in $phpDirs) {
        $PhpCgiPath = Join-Path $dir.FullName "php-cgi.exe"
        $PhpIniPath = Join-Path $dir.FullName "php.ini"

        if (Test-Path $PhpCgiPath) {
            $phpVersion = $dir.Name
            Lang-Print -Msg "ڰװ PHP-{} չ" -Arguments @($phpVersion)

            Invoke-AppCmd "set config /section:system.webServer/fastCGI /+[fullPath='$PhpCgiPath']"
            Invoke-AppCmd-NoOut "set config /section:system.webServer/handlers /+[name='PHP_FastCGI',path='*.php',verb='*',modules='FastCgiModule',scriptProcessor='$PhpCgiPath',resourceType='File']"
            Invoke-AppCmd-NoOut "set config -section:system.webServer/defaultDocument /+`"files.[value='index.php']`" /commit:apphost"
            Invoke-AppCmd "set config -section:system.webServer/fastCGI /[fullPath='$PhpCgiPath'].instanceMaxRequests:10000"
            Invoke-AppCmd "set config -section:system.webServer/fastCgi /[fullPath='$PhpCgiPath',arguments=''].activityTimeout:`"90`" /commit:apphost"
            Invoke-AppCmd "set config -section:system.webServer/fastCgi /[fullPath='$PhpCgiPath',arguments=''].requestTimeout:`"90`" /commit:apphost"
            Invoke-AppCmd "set config -section:system.webServer/fastCgi /[fullPath='$PhpCgiPath'].monitorChangesTo:`"$PhpIniPath`""
            Invoke-AppCmd "set config -section:system.webServer/fastCgi /+`"[fullPath='$PhpCgiPath'].environmentVariables.[name='PHP_FCGI_MAX_REQUESTS',value='10000']`""
        }
    }
}

# жغ
function UnInstall {

    Lang-Print -Msg "ж:{}" -Arguments @("IIS")

    sc stop w3svc
    Set-Service -Name w3svc -StartupType Disabled

    $conf_file = "$ROOT_PATH/data/iis.setup"
    if (Test-Path $conf_file) {
        Remove-Item $conf_file -Force       
    } 
    Lang-Print -Msg "ж:{}" -Arguments @("IIS")
}

function Invoke-AppCmd {
    param([string]$Command)
    Start-Process -FilePath "cmd.exe" -ArgumentList "/c $Appcmd $Command" -Wait -NoNewWindow
}

function Invoke-AppCmd-NoOut {
    param([string]$Command)
  
    cmd /c "$Appcmd $Command" > $null 2>&1
}

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "uninstall" {
        UnInstall
    }    
}
