# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

    #ҽ̣ҵ
    Lang-Print -Msg "ڰװ {}: {}" -Arguments @("Memcached", $Version)
    if (Get-Service -Name memcached -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop memcached"
        
        Delete-Panel-Service -ServiceName "memcached"
    }

    $is_2008 = $false
    $osInfo = Get-CimInstance -ClassName Win32_OperatingSystem
    if ($osInfo.Version -eq "6.1") {
        $is_2008 = $true
    }
    if ($is_2008) {
        $Version = "1.4"
    }

    #  Memcached װ·
    $memcached_dir_path = "$SOFT_PATH/memcached"
    if (-not (Test-Path $memcached_dir_path)) {
        New-Item -Path $memcached_dir_path -ItemType Directory -Force
    }
    $memcached_package_path = "$SOFT_PATH/temp/memcached.zip"
    $DownUrl = "$DownNode/win/memcached/memcached$Version.zip"

    if (-not (Download-File -Url $DownUrl -OutputPath $memcached_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("Memcached")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("Memcached")
    Un-Zip -FilePath $memcached_package_path -DestinationPath $SOFT_PATH

    Remove-VersionFiles -Path $memcached_dir_path

    $run_file = "$SOFT_PATH/memcached/runservice"
    Set-Content -Path $run_file -Value "-l 127.0.0.1 -p 11211 -m 256 -n 48 -f 1.25 -c 10000"

    $conf_file = "$memcached_dir_path/config.json"
    Set-Content -Path $conf_file -Value '{"bind": "-l 127.0.0.1", "port": "-p 11211", "cachesize": "-m 128", "minsize": "-n 48", "maxconn": "-c 2048", "factor": "-f 1.25"}'

    $memcached_server_file = "$SOFT_PATH/memcached/memcached_server.exe"
    Install-Service -ServiceName "memcached" -BinaryPathName "`"$memcached_server_file`" -m 64 -p 11211" -DisplayName "Memcached" -Description "Memcached Key-Value Store"

    if ($is_2008) {
        Lang-Print -Msg "ǰϵͳΪ Windows Server 2008  Windows 7Memcached 汾ʹ {}" -Arguments @($Version)   
    }
    Start-Service -Name memcached
    
    Write-Host "Successfully"
}

function UnInstall {
    Lang-Print -Msg "{} ж" -Arguments @("Memcached")

    Stop-Service -Name memcached -Force
    Delete-Panel-Service -ServiceName "memcached"
    
    Remove-VersionFiles -Path "$SOFT_PATH/memcached"

    Write-Host "Successfully"

}


function Upgrade() {
    param (
        [string]$Version
    )

    Lang-Print -Msg " {}" -Arguments @("Memcached")

    if (Get-Service -Name memcached -ErrorAction SilentlyContinue) {
        Stop-Service -Name memcached -Force
    }

    $conf_file = "$SOFT_PATH/memcached/config.json"
    Back-ConfigFile -FilePath $conf_file

    Install -Version $Version
    Restore-ConfigFile -FilePath $conf_file

    Start-Service -Name memcached
    Lang-Print -Msg "{} ɹ" -Arguments @("Memcached")
}


switch ($Action.ToLower()) {

    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall -Version $Version
    }    
}
