# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

     #жϷǷ
    if (Get-Service -Name mysql -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop mysql"
        Delete-Panel-Service -ServiceName "mysql"
    }

    #жϽǷ
    $mysqlProcess = Get-Process -Name "mysqld" -ErrorAction SilentlyContinue
    if ($mysqlProcess) {
        Stop-Process -Name "mysqld" -Force
    }
    
    # vc++汾
    $VcVersion = "2015"
    if ($Version -eq "5.5") {
        $VcVersion =  "2008"
    } elseif ($Version -eq "5.6") {
        $VcVersion = "2010"
    } elseif ($Version -eq "5.7") {
        $VcVersion = "2012"
    } elseif ($Version -eq "8.0") {
        $VcVersion = "2015"
    }

    Lang-Print -Msg "ڰװ{}:{}" -Arguments @("MySQL", $Version)
    if (-not (Setup-VCRedist -VcVersion $VcVersion)) {
        Lang-Print -Msg "пⰲװʧ" -Arguments @("VC++ ")
        #return
    }

    #  MySQL װ·
    $mysql_dir_path = "$SOFT_PATH/mysql"
    if (-not (Test-Path $mysql_dir_path)) {
        New-Item -Path $mysql_dir_path -ItemType Directory -Force
    }

    #  MySQL װ·
    $mysql_package_path =  "$SOFT_PATH/temp/MySQL.zip"
    $package_name = "MySQL$Version"   
    if ($Version -like "mariadb*") {
        $mariadbVersion = ($Version -match "\d+\.\d+") | Out-Null
        $package_name = "MariaDB-$($Matches[0])"
    }

    $DownUrl = "$DownNode/win/mysql/$package_name" + "_x64.zip"
    if (-not (Download-File -Url $DownUrl -OutputPath $mysql_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("MySQL")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("MySQL")
    Un-Zip -FilePath $mysql_package_path -DestinationPath $mysql_dir_path
    
    Lang-Print -Msg "ѹ{} " -Arguments @("MySQL")

    $mysql_ini_file = "$mysql_dir_path/$package_name/my.ini"
    if (-not (Test-Path $mysql_ini_file)) {
        Lang-Print -Msg "{} ļδҵ: {}" -Arguments @("MySQL", $mysql_ini_file)
        return
    }

    $mysql_conf = Get-Content -Path $mysql_ini_file -Raw
    $mysql_dir = "$mysql_dir_path/$package_name"
    $mysql_dir = $mysql_dir -replace "\\", "/"

    #滻 [PATH] Ϊ MySQL Ŀ¼
    $mysql_conf = $mysql_conf -replace "\[PATH\]", $mysql_dir    
    Set-Content -Path $mysql_ini_file -Value $mysql_conf

    Remove-VersionFiles -Path $mysql_dir
    #װ MySQL 
    $mysql_service_name = "mysql"
    $mysql_exe_path = "$mysql_dir_path/$package_name/bin/mysqld.exe"
    if (-not (Test-Path $mysql_exe_path)) {
        Lang-Print -Msg "{} ִļδҵ: {}" -Arguments @("MySQL", $mysql_exe_path)
        return
    }
    Lang-Print -Msg "ڰװ{} " -Arguments @($mysql_service_name)

    $BinaryPathName = "`"$mysql_exe_path`" --defaults-file=`"$mysql_ini_file`" MySQL"
    if (Install-Service -ServiceName $mysql_service_name -BinaryPathName $BinaryPathName -DisplayName "MySQL" -Description "MySQL Database Service") {
        Lang-Print -Msg "{} װɹ" -Arguments @($mysql_service_name)
    } else {
        Lang-Print -Msg "{} װʧ" -Arguments @($mysql_service_name)
        return
    }  
    #roo,16λ        
    $bin_file = Get-PanelFile
    if (-not $bin_file) {
        Lang-Print -Msg "ļδҵ" -Arguments @("")
        return
    }
    
    Lang-Print -Msg " {} " -Arguments @("MySQL root")
    $root_password = Generate-RandomString -Length 12
    Invoke-Cmd -Command "$bin_file --tools set_mysql_root $root_password"


    Lang-Print -Msg "ͬ {} ݿ" -Arguments @("MySQL")
    Invoke-Cmd -Command "$bin_file --tools sync_to_database mysql"

    Lang-Print -Msg "MySQL װɣroot Ϊ: {}" -Arguments @($root_password) 

    Lang-Print -Msg " {} " -Arguments @($mysql_service_name)
    Invoke-Cmd -Command "sc start $mysql_service_name"

    Write-Host "Successfully"
    return
}

function UnInstall {
    Lang-Print -Msg "ж {} " -Arguments @("MySQL")

    $mysql_service_name = "mysql"
    if (Get-Service -Name $mysql_service_name -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop $mysql_service_name"
        Delete-Panel-Service -ServiceName $mysql_service_name
    }
    Lang-Print -Msg "{} ж" -Arguments @("MySQL")
}

function Upgrade() {
    param (
        [string]$Version
    )
    Lang-Print -Msg " {}" -Arguments @("MySQL")

    if (Get-Service -Name $mysql_service_name -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop mysql"
    }
    
    $conf_file = "$SOFT_PATH/mysql/MySQL$Version/my.ini"
    Back-ConfigFile -FilePath $conf_file

    Install -Version $Version
    Restore-ConfigFile -FilePath $conf_file

    Lang-Print -Msg "{} ɹ" -Arguments @("MySQL")
}

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall
    }    
}
