# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

    Lang-Print -Msg "ڰװ Nginx:{}" -Arguments @($Version)

    Invoke-Cmd -Command "net stop http /y"    
    Set-Service -Name W3SVC -StartupType Disabled

    # жϷǷ
    if (Get-Service -Name nginx -ErrorAction SilentlyContinue) {
        Lang-Print -Msg "{} Ѵڣ׼ж" -Arguments @("Nginx")
        Set-WebServer-Status -Status "stop"
        Delete-Panel-Service -ServiceName "nginx"
    }
    #  Nginx װ·
    $nginx_dir_path = "$SOFT_PATH/nginx"
    if (-not (Test-Path $nginx_dir_path)) {
        New-Item -Path $nginx_dir_path -ItemType Directory -Force
    }

    $DownUrl = "$DownNode/win/nginx_new/nginx-$Version.zip"
    $nginx_package_path = "$SOFT_PATH/temp/nginx.zip"

    if (-not (Download-File -Url $DownUrl -OutputPath $nginx_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("Nginx")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("Nginx")
    Un-Zip -FilePath $nginx_package_path -DestinationPath $SOFT_PATH

    Set-Nginx-Ini

    Install-Service -ServiceName "nginx" -BinaryPathName "`"$nginx_dir_path/nginx_server.exe`"" -DisplayName "Nginx" -Description "Nginx Web Server"

    Set-WebServer-Status -Status "stop"
    Invoke-Cmd -Command "net stop http /y"    
    Start-Service -Name nginx

    Write-Host "Successfully"
}


function Set-Nginx-Ini{

    $nginx_conf_file = "$SOFT_PATH/nginx/config.ini"
    if (Test-Path $nginx_conf_file) {
        
        $nginx_conf = Get-Content -Path $nginx_conf_file -Raw   
        $php_dirs = Get-ChildItem -Path $SOFT_PATH/php -Directory

        $php_versions = @()
        foreach ($dir in $php_dirs) {      
            if ($dir.Name -match '^\d+(\.\d+)?$') {
                $php_versions += $dir.Name
            }
        }
        $nginx_conf = $nginx_conf -replace "path\s?=.+", "path = $SOFT_PATH"
        $nginx_conf = $nginx_conf -replace "php_versions\s?=.+", "php_versions = $($php_versions -join ',')"
        $nginx_conf = $nginx_conf -replace "php_cgi_thread\s?=.+", "php_cgi_thread = 4"
        $nginx_conf = $nginx_conf -replace "php_cgi_process\s?=.+", "php_cgi_process = 4"
        $nginx_conf = $nginx_conf -replace "php_cgi_process_thread\s?=.+", "php_cgi_process_thread = 3000"
        $nginx_conf = $nginx_conf -replace "restart_delay\s?=.+", "restart_delay = 120"
        $nginx_conf = $nginx_conf -replace "php_cgi_help_process\s?=.+", "php_cgi_help_process = 16"
        $nginx_conf = $nginx_conf -replace "php_cgi_help_process_thread\s?=.+", "php_cgi_help_process_thread = 2000"
        $nginx_conf = $nginx_conf -replace "helpers_delay\s?=.+", "helpers_delay = 120" 

        Set-Content -Path $nginx_conf_file -Value $nginx_conf
    }
}

function UnInstall {

    Lang-Print -Msg "ж:{}" -Arguments @("Nginx")
    if (Get-Service -Name nginx -ErrorAction SilentlyContinue) {
        Stop-Service -Name nginx -Force    
        Delete-Panel-Service -ServiceName "nginx"
    }
 
}

function Upgrade() {
    param (
        [string]$Version
    )

    Lang-Print -Msg " {}" -Arguments @("Nginx")

    Set-WebServer-Status -Status "stop"

    $conf_file = "$SOFT_PATH/nginx/config.ini"
    Back-ConfigFile -FilePath $conf_file

    Install -Version $Version
    Restore-ConfigFile -FilePath $conf_file
    Start-Service -Name nginx

    Lang-Print -Msg "{} " -Arguments @()
}

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall -Version $Version
    }    
}
