# ű
param (
    [string]$Action, 
    [string]$Version,
    [string]$ExtName
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version,
        [string]$ExtName
    )

    $result = Get-ExtName -ExtName $ExtName
    $local_file = "$SOFT_PATH/php/$Version/ext/$($result.FileName)"
    #
    if (-not (Test-Path $local_file)) {
        Lang-Print -Msg " {} չ: {}" -Arguments @($ExtName, $Version)
        $DownUrl = "$DownNode/win/php/$Version/$($result.FileName)"
        if (-not (Download-File -Url $DownUrl -OutputPath $local_file)) {
            Lang-Print -Msg " {} չʧ" -Arguments @($ExtName)
            return
        }
    }

    $php_ini_file = "$SOFT_PATH/php/$Version/php.ini"
    if (-not (Test-Path $php_ini_file)) {
        Lang-Print -Msg "PHP ļδҵ: {}" -Arguments @($php_ini_file)
        return
    }

    $list = @("pathinfo","path_info")
    $php_ini_content = Get-Content -Path $php_ini_file -Raw  
    if ($ExtName -in $list) {
        $php_ini_content = $php_ini_content -replace ";;*(\w+.*fix_pathinfo=).*", "cgi.fix_pathinfo=1"
    }else{
        $reg = ";*\w+.*$($result.FileName).*"
        $temp = [regex]::Match($php_ini_content, $reg)
        if ($temp.Success) {
            $php_ini_content = $php_ini_content -replace $temp.Value, $result.ExtPath
        } else {
            $php_ini_content += "`n$($result.ExtPath)"
        }   
    }
    Set-Content -Path $php_ini_file -Value $php_ini_content
    
    Lang-Print -Msg "{} չװɹ" -Arguments @($ExtName)
    if ($ExtName -eq "redis") {

    }elseif ($ExtName -eq "memcache" -or $ExtName -eq "memcached") {
     
    } 
    Write-Host "Successfully"
    return
}

function UnInstall {
  param (
        [string]$Version,
        [string]$ExtName
    )

    $result = Get-ExtName -ExtName $ExtName

    $php_ini_file = "$SOFT_PATH/php/$Version/php.ini"
    if (-not (Test-Path $php_ini_file)) {
        Lang-Print -Msg "PHP ļδҵ: {}" -Arguments @($php_ini_file)
        return
    }
    $list = @("pathinfo","path_info")
    $php_ini_content = Get-Content -Path $php_ini_file -Raw  
    if ($ExtName -in $list) {
        $php_ini_content = $php_ini_content -replace ";;*(\w+.*fix_pathinfo=).*", "cgi.fix_pathinfo=1"
    }else{
        $reg = ";*\w+.*$($result.FileName).*"
        $temp = [regex]::Match($php_ini_content, $reg)
        if ($temp.Success) {
            $php_ini_content = $php_ini_content -replace $temp.Value, ";$result.ExtPath"
        }
    }
    Set-Content -Path $php_ini_file -Value $php_ini_content
    Write-Host "Successfully"
}

function Get-ExtName {
    param (
        [string]$ExtName
    )
    $FileName = "php_$ExtName.dll"
    switch ($ExtName) {
        "sg11" { $FileName = "ixed.$Version.win" }
        "sg12" { $FileName = "sg12.ixed.$Version.win" }
        "zendguardloader" { $FileName = "ZendLoader.dll" }
        "mongo" { $FileName = "php_mongodb.dll" }
        "imagemagick" { $FileName = "php_imagick.dll" }
        default { $FileName = "php_$ExtName.dll" }
    }

    if ($ExtName -eq "zendoptimizer") {
        $FileName = "ZendExtensionManager.dll"
        $ExtPath = "zend_extension_ts=`"$SOFT_PATH/php/$Version/ZendOptimizer/$FileName`""
    } elseif ($ExtName -eq "opcache" -or $ExtName -eq "ioncube" -or $ExtName -eq "xdebug" -or $ExtName -eq "zendguardloader") {
        if ($Version -eq "53" -or $Version -eq "54") {
            $ExtPath = "zend_extension=./ext/$FileName"
        } else {
            $ExtPath = "zend_extension=$FileName" 
        }
    }else{
        $ExtPath = "extension=$FileName"
    }

    return [PSCustomObject]@{
        FileName       = $FileName
        ExtPath  = $ExtPath
    }
}

$ExtName = $ExtName.ToLower()
$Version = $Version -replace '\.', ''

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version -ExtName $ExtName
    }
    "uninstall" {
        UnInstall -Version $Version -ExtName $ExtName
    }    
}
