# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

    Lang-Print -Msg "ڰװ {}: {}" -Arguments @("phpmyadmin", $Version)
    #  phpMyAdmin װ·
    $phpmyadmin_dir_path = "$SOFT_PATH/phpmyadmin"
    if (-not (Test-Path $phpmyadmin_dir_path)) {
        New-Item -Path $phpmyadmin_dir_path -ItemType Directory -Force
    }
    #  phpMyAdmin װ·
    $phpmyadmin_package_path = "$SOFT_PATH/temp/phpmyadmin.zip"
    $DownUrl = "$DownNode/win/phpmyadmin/phpmyadmin$Version.zip"
    if (-not (Download-File -Url $DownUrl -OutputPath $phpmyadmin_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("phpMyAdmin")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("phpMyAdmin")
    Un-Zip -FilePath $phpmyadmin_package_path -DestinationPath $phpmyadmin_dir_path
    if (-not (Test-Path $phpmyadmin_dir_path)) {
        Lang-Print -Msg "phpMyAdmin װʧ" -Arguments @("")
        return
    }
    
    #16λ
    $dir_name = Generate-RandomString -Length 16 
    $dir_name = "phpmyadmin_$dir_name"  
    Set-Content -Path "$ROOT_PATH/data/phpmyadminDirName.pl" -Value $dir_name -Force

    #Ŀ¼
    $new_phpmyadmin_dir_path = "$SOFT_PATH/phpmyadmin/$dir_name"

    Write-Host $new_phpmyadmin_dir_path
    Rename-Item -Path "$phpmyadmin_dir_path/phpmyadmin" -NewName $new_phpmyadmin_dir_path

    if (-not (Test-Path $new_phpmyadmin_dir_path)) {
        Lang-Print -Msg " {} Ŀ¼ʧ" -Arguments @("phpMyAdmin")
        return
    }

    $inc_file = "$new_phpmyadmin_dir_path/config.inc.php"
    if (-not (Test-Path $inc_file)) {
       $temp_inc_file = "$new_phpmyadmin_dir_path/config.sample.inc.php"
       if (-not (Test-Path $temp_inc_file)) {
            Lang-Print -Msg "{} ļδҵ: {}" -Arguments @("phpMyAdmin", $temp_inc_file)
            return
        }
        Copy-Item -Path $temp_inc_file -Destination $inc_file
    }
   
    #  PHP 汾Ƿ֧
    $result = Check-PHP -Version $Version
    $verify_res = $result[0]
    $phpVersion = $result[1]
    if (-not $verify_res) {       
        return
    }
    $bin_file = Get-PanelFile
    if (-not $bin_file) {
        Lang-Print -Msg "ļδҵ" -Arguments @("")
        return
    }
    # phpMyAdmin  MySQL Ӷ˿
    Invoke-Cmd -Command "$bin_file --tools set_phpmyadmin_port"

    # վ
    Lang-Print -Msg " {} վ" -Arguments @("phpmyadmin")
    Invoke-Cmd -Command "$bin_file --tools add_phpmyadmin_site 888 $phpmyadmin_dir_path $phpVersion"

    #д汾Ϣ
    $version_file = "$phpmyadmin_dir_path/version.pl"
    if (-not (Test-Path $version_file)) {
        New-Item -Path $version_file -ItemType File -Force
    }
    Set-Content -Path $version_file -Value $Version -Force

    Write-Host "Successfully"
    return 
}



function Check-PHP {
    param (
        [string]$Version
    )
    $phps = @(84,83,82,81,80,74,73,72,71,70,56,55,54,53)
    switch ($Version) {
        "4.0" { $phps = @(54, 53) }
        "4.4" { $phps = @(74,73,72,71,70,56,55,54,53) } # ȫ汾֧
        "4.6" { $phps = @(70,56,55) }
        "4.7" { $phps = @(71,70,56,55) }
        "4.8" { $phps = @(72,71,70,56,55) }
        "4.9" { $phps = @(74,73,72,71,70,55,56) }
        "5.0" { $phps = @(74,73,72,71) }
        "5.1" { $phps = @(81,74,73,72,71) }
        "5.2" { $phps = @(82,81,80,74,73,72) }
        default {
            Lang-Print -Msg "ֵ֧ phpMyAdmin 汾: {}" -Arguments @($Version)
            return $false,""
        }
    }
    foreach ($php in $phps) {
        if (Test-Path "$SOFT_PATH/php/$php") {
            Lang-Print -Msg "⵽ֵ֧ PHP 汾: {}" -Arguments @($php)    
            return $true,$php
        }
    }
    $php_str = $phps -join ', '
    Lang-Print -Msg "δҵֵ֧ PHP 汾밲װ°汾֮һ: {}" -Arguments @($php_str)
    return $false,""
}

function UnInstall {

    Lang-Print -Msg "ж {}: {}" -Arguments @("phpmyadmin", $Version)
    $phpmyadmin_dir_path = "$SOFT_PATH/phpmyadmin"
    if (Test-Path $phpmyadmin_dir_path) {
        Remove-Item -Path $phpmyadmin_dir_path -Recurse -Force
    }
    Write-Host "Successfully"
}


switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "uninstall" {
        UnInstall -Version $Version
    }    
}
