# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

    #ҽ̣ҵ
    $redisProcess = Get-Process -Name "redis_server" -ErrorAction SilentlyContinue
    if ($redisProcess) {
        Stop-Process -Name "redis_server" -Force
    }
    $redisProcess = Get-Process -Name "redis-server" -ErrorAction SilentlyContinue
    if ($redisProcess) {
        Stop-Process -Name "redis-server" -Force
    }

    Lang-Print -Msg "ڰװ {}: {}" -Arguments @("Redis", $Version)
    if (Get-Service -Name redis -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop redis"
        Delete-Panel-Service -ServiceName "redis"
    }
    #  Redis װ·
    $redis_dir_path = "$SOFT_PATH/redis"
   
    $is_2008 = $false
    $osInfo = Get-CimInstance -ClassName Win32_OperatingSystem
    if ($osInfo.Version -eq "6.1") {
        $is_2008 = $true
    }
    if ($is_2008) {
        $Version = "3.2"       
    }
    $redis_package_path = "$SOFT_PATH/temp/redis.zip"
    $DownUrl = "$DownNode/win/redis/redis$Version.zip"
    
    
    Download-File -Url $DownUrl -OutputPath $redis_package_path

    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("Redis")
    Un-Zip -FilePath $redis_package_path -DestinationPath $SOFT_PATH

    if (-not (Test-Path $redis_dir_path)) {
        New-Item -Path $redis_dir_path -ItemType Directory -Force
    }
    Remove-VersionFiles -Path $redis_dir_path

    $redis_list = @("3.2","5.0","5.1","5.2","5.3","5.4","5.5")
    if ($Version -in $redis_list) {
        $redis_server_file = "$SOFT_PATH/redis/redis-server.exe"
        Install-Service -ServiceName "redis" -BinaryPathName "`"$redis_server_file`" --service-run redis.windows.conf --loglevel verbose" -DisplayName "Redis" -Description "Redis Key-Value Store"
    } else {
        $redis_server_file = "$SOFT_PATH/redis/redis_server.exe"
        Install-Service -ServiceName "redis" -BinaryPathName "`"$redis_server_file`"" -DisplayName "Redis" -Description "Redis Key-Value Store"
    }
    Start-Service -Name redis

    Lang-Print -Msg "װ {}: {}" -Arguments @("Redis", $Version)
    if ($is_2008) {
        Lang-Print -Msg "ǰϵͳΪ Windows Server 2008  Windows 7Redis 汾ʹ {}" -Arguments @($Version)
    } 
    Write-Host "Successfully"
}

function UnInstall {
    Lang-Print -Msg "ж {} " -Arguments @("Redis")

    if (Get-Service -Name redis -ErrorAction SilentlyContinue) {
        Stop-Service -Name redis -Force
        Delete-Panel-Service -ServiceName "redis"
    }

    $redis_dir_path = "$SOFT_PATH/redis"
    if (Test-Path $redis_dir_path) {
        Remove-Item -Path $redis_dir_path -Recurse -Force
    }
    
    Lang-Print -Msg "{} ж" -Arguments @("Redis")
}


    # def update_soft(self,downurl):
    #     public.kill('redis_server.exe')
    #     public.kill('redis-server.exe')
    #     path = self._setup_path + '/redis'
    #     sfile = path +'/redis.windows.conf'
    #     dfile = path + 'redis.windows.conf.backup'
    #     shutil.copy (sfile,dfile)
    #     rRet = self.install_soft(downurl)
    #     if not rRet['status'] : rRet;
    #     if public.set_server_status(self._name,'stop'):
    #         shutil.copy (dfile,sfile)
    #         os.remove(dfile);
    #         if public.set_server_status(self._name,'start'):
    #              return public.returnMsg(True,'³ɹ!');
    #     return public.returnMsg(False,'ʧ!');


function Upgrade() {
    param (
        [string]$Version
    )
    Lang-Print -Msg " {}" -Arguments @("Redis")
    
    Stop-Process -Name "redis_server.exe" -Force
    Stop-Process -Name "redis-server.exe" -Force
    Stop-Service -Name redis -Force

    $conf_file = "$SOFT_PATH/redis/redis.windows.conf"
    Back-ConfigFile -FilePath $conf_file

    Install -Version $Version
    Restore-ConfigFile -FilePath $conf_file

    Start-Service -Name redis
    Lang-Print -Msg "{} ɹ" -Arguments @("Redis")
}

switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "upgrade" {
        Upgrade -Version $Version
    }
    "uninstall" {
        UnInstall
    }    
}
