# ű
param (
    [string]$Action, 
    [string]$Version
)
. .\comm.ps1 


function Install {
    param (
        [string]$Version
    )

    #жϷǷ
    if (Get-Service -Name MSSQLSERVER -ErrorAction SilentlyContinue) {
        Lang-Print -Msg "{} Ѵڣظװ" -Arguments @("SQL Server")
        return 
    }

    Lang-Print -Msg "ڰװ {}: {}" -Arguments @("SQL Server", $Version)
    #  SQL Server װ·
    $sql_dir_path = "$SOFT_PATH/sqlserver"
    if (-not (Test-Path $sql_dir_path)) {
        New-Item -Path $sql_dir_path -ItemType Directory -Force
    }
    #  SQL Server װ·
    $sql_package_path = "$SOFT_PATH/temp/sqlserver.zip"
    $DownUrl = "$DownNode/win/SqlServer/sql$Version" + "_x64.zip"
    if (-not (Download-File -Url $DownUrl -OutputPath $sql_package_path)) {
        Lang-Print -Msg " {} װʧ" -Arguments @("SQL Server")
        return
    }
    Lang-Print -Msg "ڽѹ {} װ" -Arguments @("SQL Server")
    Un-Zip -FilePath $sql_package_path -DestinationPath $sql_dir_path

    #8λ
    $password = [System.Web.Security.Membership]::GeneratePassword(8, 4)
    $password = "sqlserver_$password"

    $sa_file = "$ROOT_PATH/data/sa.pl"
    if (-not (Test-Path -Path $sa_file)) {
        New-Item -Path $sa_file -ItemType File -Force | Out-Null
    }   
    Set-Content -Path $sa_file -Value $password
    Remove-VersionFiles -Path $sql_dir_path

    if ($Version -eq "2005") {
        
        $bat_file = "$sql_dir_path/setup.bat"
        if (-not (Test-Path -Path $bat_file)) {
            Lang-Print -Msg "SQL Server 2005 װűδҵ: {}" -Arguments @($bat_file)
            return
        }

        $sql_path = $sql_dir_path -replace "/", "\\"

        $conf = Get-Content -Path $bat_file -Raw
        $conf = $conf -replace "\[PASSWORD\]", $password
        $conf = $conf -replace "\[PATH\]", $sql_path

        Set-Content -Path $bat_file -Value $conf
        Lang-Print -Msg "Windows޷Զװ˳ֶаװĿ¼setup.batһװ." -Arguments @("")
        return
    } else {
        Lang-Print -Msg ".Net3.5(2-3)" -Arguments @("")
        Invoke-Cmd-NoOut "DISM /Online /Enable-Feature /FeatureName:NetFx3 /n"
        Invoke-Cmd-NoOut "DISM /Online /Enable-Feature /all /FeatureName:NetFx3 /n"
        Invoke-Cmd-NoOut "DISM /online /enable-feature /all /featurename:IIS-ASPNET45 /n"

        $ini_file = "$sql_dir_path/ConfigurationFile.ini"
        if (-not (Test-Path $ini_file)) {
            Lang-Print -Msg "SQL Server ļδҵ: {}" -Arguments @($ini_file)
            return
        }
        $conf = Get-Content -Path $ini_file -Raw
        $conf = $conf -replace "\[PASSWORD\]", $password
        $conf = $conf -replace "\[PATH\]", $sql_dir_path -replace "/", "\\"
        Set-Content -Path $ini_file -Value $conf

       # ݰ汾̬ðװļ·
        $setup_file = "$sql_dir_path/SQLEXPR_${Version}_x64.exe"
        if ($Version -ne "2012" -and $Version -ne "2008") {
            $setup_file = "$sql_dir_path/SQLEXPR_${Version}_x64/setup.exe"
        }
        if (-not (Test-Path $setup_file)) {
            Lang-Print -Msg "{} װδҵ: {}" -Arguments @("SQL Server", $setup_file)
            return
        }
       
        # 尲װ·ļ·
        $to_shell = ""
        if ($Version -eq "2017") {
            $to_shell = "$sql_dir_path/SSMS-Setup-CHS.exe"
        }

        $tip1 = Lang-Ctx -Msg "װɣ {} Ҫ GUI ֧֣ҪͨҪ²" -Arguments @("SQL Server")
        $tip2 = Lang-Ctx -Msg "ͨ {}" -Arguments @("SQL Server")
        $tip3 = Lang-Ctx -Msg "ҵȫ - ¼ - NT AUTHORITY\SYSTEM -  - ɫ - ѡбе sysadmin" -Arguments @("")
        $tip4 = Lang-Ctx -Msg " {} " -Arguments @("SQL Server")
        $tip5 = Lang-Ctx -Msg "ɰװ" -Arguments @("")

        # 尲װɺʾϢ
        $tps = "@echo $tip1 
        @echo $tip2
        @echo $tip3
        @echo $tip4
        @echo $tip5"

        $tip6 = Lang-Ctx -Msg "ڰװ {} ʧܿɳװ" -Arguments @("SQL Server")
        $tip7 = Lang-Ctx -Msg "װɹ" -Arguments @("")

# װű
$shell = @"
cd $sql_dir_path
@echo ...
`"$setup_file`" /QS /ACTION=Install /ConfigurationFile=`"$ini_file`" /IACCEPTSQLSERVERLICENSETERMS /SAPWD=`"$password`" /SQLSYSADMINACCOUNTS=`"Administrator`"
@echo $tip7
$to_shell
$tps
pause
"@

        # д밲װű setup.bat ļ
        $bat_file = "$sql_dir_path/setup.bat"
        Set-Content -Path $bat_file -Value $shell -Encoding Default

        # װű·
        Lang-Print -Msg "װű: {}" -Arguments @($bat_file)

        # ִаװű
        Lang-Print -Msg "ִаװű..." -Arguments @("")
        Start-Process -FilePath "cmd.exe" -ArgumentList "/c `"$bat_file`"" -Wait -NoNewWindow

        Lang-Print -Msg "Windows޷Զװ˳ֶаװĿ¼setup.batһװ." -Arguments @("")
        return
    }
}

function UnInstall {
    Lang-Print -Msg "ж {} " -Arguments @("SQL Server")

    # ֹͣ SQL Server 
    if (Get-Service -Name MSSQLSERVER -ErrorAction SilentlyContinue) {
        Invoke-Cmd -Command "sc stop MSSQLSERVER"
        Invoke-Cmd -Command "sc delete MSSQLSERVER"
    }

    Lang-Print -Msg "{} ж" -Arguments @("SQL Server")
}


switch ($Action.ToLower()) {
    "install" {       
        Install -Version $Version
    }
    "uninstall" {
        UnInstall
    }    
}
