server:
  # 基本配置
  address: ":8000"
  httpsAddr: ":50443"
  httpsCertPath: "./data/cert/vhost.crt"
  httpsKeyPath: "./data/cert/vhost.key"
  readTimeout: "600s"
  writeTimeout: "0"
  idleTimeout: "60s"
  maxHeaderBytes: "10240"
  keepAlive: true
  serverAgent: "nginx"

  # 接口文档
  openapiPath: "/api.json" # OpenAPI接口文档地址
  swaggerPath: "/swagger"  # 内置SwaggerUI展示地址



  # 静态服务配置
  #indexFiles: ["index.html", "index.htm"]
  #indexFolder: false
  #serverRoot: "static/dist"
  #searchPaths: ["static/html"]
  #fileServerEnabled: true

  # Cookie配置
  cookieMaxAge: "365d"
  cookiePath: "/"
  cookieDomain: ""

  # Sessions配置
  sessionMaxAge: "24h"
  sessionIdName: "account"
  sessionCookieOutput: true
  sessionPath: "./data/session"

  # 日志基本配置
  logPath: "logs"
  logStdout: true
  errorStack: true
  errorLogEnabled: true
  errorLogPattern: "error-{Ymd}.log"
  accessLogEnabled: true
  accessLogPattern: "access-{Ymd}.log"

  # PProf配置
  pprofEnabled: false # 是否开启PProf性能调试特性。默认为false
  pprofPattern: "" # 开启PProf时有效，表示PProf特性的页面访问路径，对当前Server绑定的所有域名有效。

  # 其他配置
  clientMaxBodySize: 810241024 # 客户端最大Body上传限制大小，影响文件上传大小(Byte)。默认为8*1024*1024=8MB
  formParsingMemory: 1048576 # 解析表单时的缓冲区大小(Byte)，一般不需要配置。默认为1024*1024=1MB
  dumpRouterMap: false # 是否在Server启动时打印所有的路由列表。默认为true

viewer:
  Paths: ["template"]

# 日志配置
logger:
  path: "logs/out" # 日志文件路径。默认为空，表示关闭，仅输出到终端
  file: "{Y-m-d}.log" # 日志文件格式。默认为"{Y-m-d}.log"
  prefix: "" # 日志内容输出前缀。默认为空
  level: "all" # 日志输出级别
  timeFormat: "2006-01-02T15:04:05" # 自定义日志输出的时间格式，使用Golang标准的时间格式配置
  ctxKeys: [] # 自定义Context上下文变量名称，自动打印Context的变量到日志中。默认为空
  header: true # 是否打印日志的头信息。默认true
  stdout: true # 日志是否同时输出到终端。默认true
  rotateSize: 0 # 按照日志文件大小对文件进行滚动切分。默认为0，表示关闭滚动切分特性
  rotateExpire: 0 # 按照日志文件时间间隔对文件滚动切分。默认为0，表示关闭滚动切分特性
  rotateBackupLimit: 0 # 按照切分的文件数量清理切分文件，当滚动切分特性开启时有效。默认为0，表示不备份，切分则删除
  rotateBackupExpire: 0 # 按照切分的文件有效期清理切分文件，当滚动切分特性开启时有效。默认为0，表示不备份，切分则删除
  rotateBackupCompress: 0 # 滚动切分文件的压缩比（0-9）。默认为0，表示不压缩
  rotateCheckInterval: "1h" # 滚动切分的时间检测间隔，一般不需要设置。默认为1小时
  stdoutColorDisabled: true # 关闭终端的颜色打印。默认开启
  writerColorEnable: false # 日志文件是否带上颜色。默认false，表示不带颜色

# 配置数据库
database:
  default:
    type: "sqlite"
    link: "sqlite::@file(./data/db/default.db)"
    debug: false
  #crontab数据库
  crontab:
    type: "sqlite"
    link: "sqlite::@file(./data/db/crontab.db)"
  #ftp数据库
  ftp:
    type: "sqlite"
    link: "sqlite::@file(./data/db/ftp.db)"

  #日志数据库
  log:
    type: "sqlite"
    link: "sqlite::@file(./data/db/log.db)"

  # 网站管理数据库
  site:
    type: "sqlite"
    link: "sqlite::@file(./data/db/site.db)"

  # 数据库管理模块数据库
  database:
    type: "sqlite"
    link: "sqlite::@file(./data/db/database.db)"

  #脚本数据库
  script:
    type: "sqlite"
    link: "sqlite::@file(./data/db/script.db)"

  #任务数据库
  task:
    type: "sqlite" 
    link: "sqlite::@file(./data/db/task.db)"

  #备份数据库
  backup:
    type: "sqlite"
    link: "sqlite::@file(./data/db/backup.db)"

  
  #监控数据库
  system:
    type: "sqlite"
    link: "sqlite::@file(./data/system.db)"

  #面板基础配置
  panel:
    type: "sqlite"
    link: "sqlite::@file(./data/db/panel.db)"