/**
 * 宝塔Linux面板免费版 - 专题页交互逻辑
 */

// DOMContentLoaded 事件
document.addEventListener('DOMContentLoaded', function() {
    initInstallTabs();
    initOperationTabs();
    initScrollAnimations();
});

/**
 * 安装脚本标签切换
 */
function initInstallTabs() {
    const tabsNav = document.querySelector('.install-tabs-nav');
    const selectEl = document.getElementById('install-os-select');
    const codeBlock = document.getElementById('install-code');
    
    // 安装脚本命令映射
    const installScripts = {
        universal: 'if [ -f /usr/bin/curl ];then curl -sSO https://download.bt.cn/install/install_panel.sh;else wget -O install_panel.sh https://download.bt.cn/install/install_panel.sh;fi;bash install_panel.sh ed8484bec',
        centos: 'url=https://download.bt.cn/install/install_panel.sh;if [ -f /usr/bin/curl ];then curl -sSO $url;else wget -O install_panel.sh $url;fi;bash install_panel.sh ed8484bec',
        ubuntu: 'wget -O install_panel.sh https://download.bt.cn/install/install_panel.sh && bash install_panel.sh ed8484bec',
        debian: 'wget -O install_panel.sh https://download.bt.cn/install/install_panel.sh && sudo bash install_panel.sh ed8484bec'
    };
    
    // 更新代码内容的函数
    function updateCode(os) {
        if (codeBlock && installScripts[os]) {
            codeBlock.style.opacity = '0.5';
            setTimeout(() => {
                codeBlock.textContent = installScripts[os];
                codeBlock.style.opacity = '1';
            }, 150);
        }
    }
    
    // 按钮切换
    if (tabsNav) {
        const tabs = tabsNav.querySelectorAll('.install-tab');
        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                tabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                
                const os = this.getAttribute('data-os');
                updateCode(os);
                
                // 同步更新下拉框
                if (selectEl) {
                    selectEl.value = os;
                }
            });
        });
    }
    
    // 下拉框切换
    if (selectEl) {
        selectEl.addEventListener('change', function() {
            const os = this.value;
            updateCode(os);
            
            // 同步更新按钮状态
            if (tabsNav) {
                const tabs = tabsNav.querySelectorAll('.install-tab');
                tabs.forEach(tab => {
                    if (tab.getAttribute('data-os') === os) {
                        tab.classList.add('active');
                    } else {
                        tab.classList.remove('active');
                    }
                });
            }
        });
    }
}

/**
 * 运维功能标签切换
 */
function initOperationTabs() {
    const tabs = document.querySelectorAll('.tab-item');
    const previewImages = document.querySelectorAll('.preview-image');
    const tabsContainer = document.querySelector('.operation-tabs');
    
    tabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // 移除所有 tab 活动状态
            tabs.forEach(t => t.classList.remove('active'));
            // 添加当前 tab 活动状态
            this.classList.add('active');
            
            // 获取当前选中的索引
            const index = parseInt(this.getAttribute('data-index'));
            
            // 切换图片显示
            previewImages.forEach(img => {
                const imgIndex = parseInt(img.getAttribute('data-index'));
                if (imgIndex === index) {
                    img.classList.add('active');
                } else {
                    img.classList.remove('active');
                }
            });
            
            // 移动端：滚动选中 tab 到可视区域
            if (window.innerWidth <= 768 && tabsContainer) {
                const tabRect = this.getBoundingClientRect();
                const containerRect = tabsContainer.getBoundingClientRect();
                const scrollLeft = tabsContainer.scrollLeft;
                const isLast = index === tabs.length - 1;
                
                if (isLast) {
                    // 最后一个：滚动到最右边
                    tabsContainer.scrollTo({
                        left: tabsContainer.scrollWidth - containerRect.width,
                        behavior: 'smooth'
                    });
                } else {
                    // 其他：滚动到中央
                    const tabCenter = tabRect.left + tabRect.width / 2 - containerRect.left;
                    const containerCenter = containerRect.width / 2;
                    const targetScroll = scrollLeft + tabCenter - containerCenter;
                    
                    tabsContainer.scrollTo({
                        left: targetScroll,
                        behavior: 'smooth'
                    });
                }
            }
        });
    });
}

/**
 * 复制代码到剪贴板
 */
function copyCode() {
    const codeBlock = document.getElementById('install-code');
    if (!codeBlock) return;
    
    const code = codeBlock.textContent;
    
    // 创建临时textarea元素
    const textarea = document.createElement('textarea');
    textarea.value = code;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    
    // 选择并复制
    textarea.select();
    textarea.setSelectionRange(0, 99999); // 移动端兼容
    
    try {
        // 尝试使用新的 Clipboard API
        if (navigator.clipboard && window.isSecureContext) {
            navigator.clipboard.writeText(code).then(() => {
                copyTipsText();
            }).catch(() => {
                // 降级方案
                document.execCommand('copy');
                copyTipsText();
            });
        } else {
            // 使用传统方法
            const successful = document.execCommand('copy');
            if (successful) {
                copyTipsText();
            } else {
                layer.msg('复制失败，请手动选中文本Ctrl+c复制内容', { icon: 2 });
            }
        }
    } catch (err) {
        layer.msg('复制失败，请手动选中文本Ctrl+c复制内容', { icon: 2 });
    }
    
    // 移除临时元素
    document.body.removeChild(textarea);
}

/**
 * 显示复制反馈
 */
function showCopyFeedback(message) {
    const copyBtn = document.querySelector('.copy-btn');
    if (!copyBtn) return;
    
    const originalHTML = copyBtn.innerHTML;
    const originalBg = copyBtn.style.background;
    
    // 保留图标，只替换文本
    const icon = copyBtn.querySelector('svg');
    if (icon) {
        copyBtn.innerHTML = '';
        copyBtn.appendChild(icon);
        copyBtn.appendChild(document.createTextNode(message));
    } else {
        copyBtn.textContent = message;
    }
    
    copyBtn.style.background = message.includes('成功') ? '#4CAF50' : '#FF5252';
    
    setTimeout(() => {
        copyBtn.innerHTML = originalHTML;
        copyBtn.style.background = originalBg;
    }, 2000);
}

/**
 * 滚动动画效果
 */
function initScrollAnimations() {
    // 动画已禁用，直接显示所有元素
    const animatedElements = document.querySelectorAll(
        '.feature-card, .function-item, .install-step, .operation-content'
    );
    
    animatedElements.forEach(el => {
        el.style.opacity = '1';
        el.style.transform = 'none';
    });
}

/**
 * 平滑滚动到锚点
 */
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function(e) {
        const href = this.getAttribute('href');
        if (href === '#') return;
        
        e.preventDefault();
        const target = document.querySelector(href);
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

/**
 * 表单选择器交互增强
 */
document.querySelectorAll('.form-select').forEach(select => {
    select.addEventListener('change', function() {
        // 添加选择反馈动画
        this.style.borderColor = '#4CAF50';
        setTimeout(() => {
            this.style.borderColor = '';
        }, 300);
    });
});

/**
 * 特性卡片悬停效果增强
 */
document.querySelectorAll('.feature-card').forEach(card => {
    card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-4px) scale(1.01)';
    });
    
    card.addEventListener('mouseleave', function() {
        this.style.transform = '';
    });
});


// 安装成功的提示
function copyTipsText() {
    var options = { width: '490px', closeBtn: 2, mode: 'default' }
    if ($(window).width() < 490) options = { width: '100%', closeBtn: 1, mode: 'small' }
    return layer.open({
        type: 1,
        title: false,
        closeBtn: 2,
        area: options.width,
        shadeClose: true,
        content: '<div class="copy-tips-main ' + options.mode + '">' +
            '<div class="copy-tips-title copy-tips-bg">' +
            '<div class="flex justify-center items-center">' +
            '<div class="copy-tips-icon"></div>' +
            '<div>安装命令复制成功</div>' +
            '</div>' +
            '<div class="flex" style="text-align: center; border-bottom: 1px dashed #e5e7eb; height: 35px;"><a href="https://docs.bt.cn/getting-started/quick-installation-of-bt-panel" target="_blank" style="font-size: 14px; margin-top:10px; color:#fcfcfc; text-decoration: none;">不会安装，点我学习</a></div>' +
            '<div class="copy-countdown-close" id="countdownClose"><span></span>秒后，自动关闭界面</div>' +
            '</div>' +
            '<div class="copy-content">' +
            '<div class="copy-content-text">感谢您使用宝塔面板！您的支持是我们前行的动力。</br>如遇到安装故障/使用问题，请<span class="customerService">联系客服</span>或<a href="https://docs.bt.cn/" target="_blank">查看使用手册</a>。</div>' +
            '</div>' +
            '</div>',
        success: function (layero) {
            var cTips = -1;
            $(layero).find('.customerService').hover(function (e) {
                layer.close(cTips);
                cTips = -1
                if (cTips === -1) {
                    var that = $(this);
                    var content = '\
                    <div style="text-align: center;padding: 8px 16px;">\
                        <div style="font-weight:700;color:#28bb45;font-size: 13px;padding: 5px;">遇到问题？加我解决</div>\
                        <img src="https://www.bt.cn/Public/images/wechat-all.png" style="width: 118px;height: 118px;" alt=""/>\
                        <div class="wechat-title">\
                            <img class="icon" style="height: 16px;vertical-align: middle;margin-right: 5px;" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAYAAADE6YVjAAAAAXNSR0IArs4c6QAAATlJREFUSEvtVrFOw0AMfed8AxJsZWGAgQHBXP4DCQa+Ioou7g18BRIg9T/KDGJggIGFbiDxDXGQowSBuGvrFISEmtF+7/nis312RVEMiWgIoMT375aIjpj5KeJrTMy8JSJjAPsRzEhErl1Zlhd1XZ8kRKZEdMjM0xlBBiIyATCIYZxzl857X6uTiHaY+TElZrUz87aIPCjvI0gIwVmF5uG7H1gFmZepxv85XTdqCCEcLMQ0gLz3jbbTOm/rPdkLBt0v0E77xysq2it9T2nhuTzPN4ho10KyYEXkXvvkBcC6hWjEvmqQMwCnANZa8p1RJAbfa41vAM7/0cUzczOiZ43zvunrtPVOntuO3+wrluJ12qspvFBm/+bR+u03nhPrkKZk2ZVINUZO964sy44Ta9FSK5GuQ1VVXb0DLf+sHQ9tLL0AAAAASUVORK5CYII=">\
                            <span class="scan-title" style="vertical-align: middle;font-size: 14px;color: #7e7e7e;">微信扫码</span></div>\
                    </div>';
                    cTips = layer.tips(content, that, {
                        time: 0,
                        area: 'auto',
                        tips: [3, '#fff'],
                        skin: 'layer-question',
                        success: function ($layer) {
                            $layer.find('.layui-layer-content').css('padding', '0');
                        },
                    });
                }
                e.stopPropagation();
            }, function () {
                cTips = null
                layer.closeAll('tips');
            });

            var countdownFn = function (closeTime) {
                var countdown = closeTime;
                var text = $(layero).find('#countdownClose span');
                text.text(countdown);
                var countdownTimer = setInterval(function () {
                    countdown--;
                    text.text(countdown);
                    if (countdown <= 0) {
                        clearInterval(countdownTimer);
                        layer.closeAll();
                    }
                }, 1000);
            }
            countdownFn(10)
        }
    })
}